<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-06-04
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\System\Config\Connection;

use Fastmag\Sync\Exception\NoConnectionException;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\System\Connection\Edi\Config as EdiConfig;
use Fastmag\Sync\Model\System\Connection\Edi\Test as EdiTestConnection;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;

/**
 * Class Edi
 *
 * EDI connection test action
 */
class Edi extends Action
{
    /** @var string */
    public const ADMIN_RESOURCE = 'Fastmag_Sync::config';

    /** @var JsonFactory $resultJsonFactory */
    protected $resultJsonFactory;

    /** @var EdiTestConnection $testConnection */
    private $testConnection;

    /** @var Logger $logger */
    protected $logger;

    /** @var EdiConfig $ediConfig */
    protected $ediConfig;

    /**
     * Edi constructor
     *
     * @param Context           $context
     * @param JsonFactory       $resultJsonFactory
     * @param EdiTestConnection $testConnection
     * @param Logger            $logger
     * @param EdiConfig         $ediConfig
     */
    public function __construct(
        Context $context,
        JsonFactory $resultJsonFactory,
        EdiTestConnection $testConnection,
        Logger $logger,
        EdiConfig $ediConfig
    ) {
        parent::__construct($context);

        $this->resultJsonFactory = $resultJsonFactory;
        $this->testConnection = $testConnection;
        $this->logger = $logger;
        $this->ediConfig = $ediConfig;
    }

    /**
     * @inheritDoc
     */
    public function execute()
    {
        $result = ['test_connect' => 0];

        $host = $this->getRequest()->getParam('host');
        $port = $this->getRequest()->getParam('port');
        $chain = $this->getRequest()->getParam('chain');
        $shop = $this->getRequest()->getParam('shop');
        $username = $this->getRequest()->getParam('user');
        $password = $this->getRequest()->getParam('password');
        $ssl = $this->getRequest()->getParam('ssl');

        try {
            if (isset($host, $port, $chain, $shop, $username, $password, $ssl)) {
                $response = $this->testConnection->execute(
                    $this->ediConfig->formatConfig($host, $port, $chain, $shop, $username, $password, $ssl)
                );

                if ($response === true) {
                    $result['test_connect'] = 1;
                } else {
                    $result['message'] = __('EDI connection - Error');
                }
            }
        } catch (NoConnectionException $e) {
            $result['message'] = __('EDI connection - Error: %1', $e->getMessage());
        }

        $resultJson = $this->resultJsonFactory->create();

        return $resultJson->setData($result);
    }
}
