<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-02-26
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\System\Config\Connection;

use Exception;
use Fastmag\Sync\FastmagSetup\Installer;
use Fastmag\Sync\FastmagSetup\Uninstaller;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\System\Connection\Sql\DirectSql;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;

/**
 * Class Triggers
 *
 * Controller allowing the reinstallaton of the triggers on Fastmag DB
 */
class Triggers extends Action
{
    /** @var string */
    public const ADMIN_RESOURCE = 'Fastmag_Sync::triggers';

    /** @var JsonFactory $resultJsonFactory */
    protected $resultJsonFactory;

    /** @var DirectSql $connection */
    protected $connection;

    /** @var Logger $logger s*/
    protected $logger;

    /** @var Installer $installer */
    protected $installer;

    /** @var Uninstaller $uninstaller */
    protected $uninstaller;

    /** @var Config $config */
    protected $config;

    /**
     * Triggers constructor
     *
     * @param Context     $context
     * @param JsonFactory $resultJsonFactory
     * @param DirectSql   $connection
     * @param Logger      $logger
     * @param Installer   $installer
     * @param Uninstaller $uninstaller
     * @param Config      $config
     */
    public function __construct(
        Context $context,
        JsonFactory $resultJsonFactory,
        DirectSql $connection,
        Logger $logger,
        Installer $installer,
        Uninstaller $uninstaller,
        Config $config
    ) {
        parent::__construct($context);

        $this->resultJsonFactory = $resultJsonFactory;
        $this->connection = $connection;
        $this->logger = $logger;
        $this->installer = $installer;
        $this->uninstaller = $uninstaller;
        $this->config = $config;
    }

    /**
     * @inheritDoc
     */
    public function execute()
    {
        try {
            $this->reinstallTriggers();

            $result = [
                'triggers_reinstalled' => 1,
                'message' => __('The triggers have been reinstalled.')
            ];
        } catch (Exception $e) {
            $result = [
                'triggers_reinstalled' => 0,
                'message' => __('Unable to reinstall triggers. Error: %1', $e->getMessage())
            ];
        }

        $resultJson = $this->resultJsonFactory->create();

        return $resultJson->setData($result);
    }

    /**
     * Reinstall triggers on Fastmag using SQL proxy
     *
     * @throws Exception
     */
    public function reinstallTriggers()
    {
        $sql = $this->uninstaller->getUninstallQueries();

        foreach ($sql as $entityType) {
            foreach ($entityType as $query) {
                $this->connection->post($query);
            }
        }

        $sql = $this->installer->getInstallQueries();

        $sql['triggers'] = $this->filterTriggersByConfig($sql['triggers']);

        foreach ($sql as $entityType) {
            foreach ($entityType as $query) {
                $this->connection->multiPost($query);
            }
        }
    }

    /**
     * Filter the triggers list to install given the configuration of the Magento instance
     *
     * @param array $triggersList
     *
     * @return array
     */
    protected function filterTriggersByConfig($triggersList)
    {
        if (!$this->config->isSetFlag(Config::XML_PATH_PRODUCT_PRICE_MANAGE_TIER_PRICES)) {
            unset(
                $triggersList['trigger_fmsync_produits_promo_insert'],
                $triggersList['trigger_fmsync_produits_promo_update'],
                $triggersList['trigger_fmsync_produits_promo_delete'],
                $triggersList['trigger_fmsync_produits_promotc_insert'],
                $triggersList['trigger_fmsync_produits_promotc_update'],
                $triggersList['trigger_fmsync_produits_promotc_delete']
            );
        }

        return $triggersList;
    }
}
