<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-06-21
 ******************************************************************************/

namespace Fastmag\Sync\Model;

use Magento\Framework\App\MutableScopeConfig;

/**
 * Class Config
 *
 * Config getter for all Fastmag Sync classes
 * Substitute ScopeConfig class and contains all the config fields added by the plugin
 */
class Config extends MutableScopeConfig
{
    /** @var string */
    public const XML_PATH_ABOUT_WEBSITE_ID = 'fastmag_sync_about/technical_data/website_id';

    /** @var string */
    public const XML_PATH_CONNECT_PRECONFIG_TODO = 'fastmag_sync_connect/state/preconfig_todo';

    /** @var string */
    public const XML_PATH_CONNECT_API_HOST = 'fastmag_sync_connect/api/host';

    /** @var string */
    public const XML_PATH_CONNECT_API_CHAIN = 'fastmag_sync_connect/api/chain';

    /** @var string */
    public const XML_PATH_CONNECT_API_SHOP = 'fastmag_sync_connect/api/shop';

    /** @var string */
    public const XML_PATH_CONNECT_API_USER = 'fastmag_sync_connect/api/user';

    /** @var string */
    public const XML_PATH_CONNECT_API_PASSWORD = 'fastmag_sync_connect/api/password';

    /** @var string */
    public const XML_PATH_CONNECT_PROXY_NATIVE_SQL_CONNECTION = 'fastmag_sync_connect/proxy/native_sql_connection';

    /** @var string */
    public const XML_PATH_JOBQUEUE_SYNC_ENABLED = 'fastmag_sync_jobqueue/sync/enable';

    /** @var string */
    public const XML_PATH_JOBQUEUE_SYNC_WEBSITE_ID = 'fastmag_sync_jobqueue/sync/website_id';

    /** @var string */
    public const XML_PATH_JOBQUEUE_ADVANCED_REACTIVITY = 'fastmag_sync_jobqueue/advanced/reactivity';

    /** @var string */
    public const XML_PATH_JOBQUEUE_ADVANCED_JOBS_LIMIT = 'fastmag_sync_jobqueue/advanced/jobs_limit';

    /** @var string */
    public const XML_PATH_JOBQUEUE_ADVANCED_HYDRATION_SIZE = 'fastmag_sync_jobqueue/advanced/hydration_size';

    /** @var string */
    public const XML_PATH_PRODUCT_IMPORT_ENABLE = 'fastmag_sync_products/import/enable';

    /** @var string */
    public const XML_PATH_PRODUCT_IMPORT_ONLY_INVENTORY = 'fastmag_sync_products/import/only_inventory';

    /** @var string */
    public const XML_PATH_PRODUCT_IMPORT_ACTIVE_VISIBLEWEB = 'fastmag_sync_products/import/only_active_visibleweb';

    /** @var string */
    public const XML_PATH_PRODUCT_IMPORT_ONLY_STORESELLER = 'fastmag_sync_products/import/only_defined_storeseller';

    /** @var string */
    public const XML_PATH_PRODUCT_PRICE_MANAGE_TIER_PRICES = 'fastmag_sync_products/price/manage_tiers_price';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_FAMILY = 'fastmag_sync_products/other_attributes/sync_family';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_SUBFAMILY
        = 'fastmag_sync_products/other_attributes/sync_subfamily';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_SECTION = 'fastmag_sync_products/other_attributes/sync_section';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_SEASON = 'fastmag_sync_products/other_attributes/sync_season';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_MODEL = 'fastmag_sync_products/other_attributes/sync_model';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_MATERIAL
        = 'fastmag_sync_products/other_attributes/sync_material';

    /** @var string */
    public const XML_PATH_PRODUCT_OTHER_ATTRIBUTES_SYNC_THEME = 'fastmag_sync_products/other_attributes/sync_theme';

    /** @var string */
    public const XML_PATH_CUSTOMER_IMPORT_ENABLE = 'fastmag_sync_customers/import/enable';

    /** @var string */
    public const XML_PATH_CUSTOMER_IMPORT_INACTIVE_CUSTOMERS = 'fastmag_sync_customers/import/inactive_customers';

    /** @var string */
    public const XML_PATH_CUSTOMER_IMPORT_ACCOUNT_EMAIL = 'fastmag_sync_customers/import/account_email';

    /** @var string */
    public const XML_PATH_CUSTOMER_IMPORT_SHOP_PURCHASES = 'fastmag_sync_customers/import/shop_purchases';

    /** @var string */
    public const XML_PATH_ORDER_WORKFLOW_INVENTORY_TRANSFER = 'fastmag_sync_orders/workflow/inventory_transfer';

    /** @var string */
    public const XML_PATH_LOG_API_CALLS = 'fastmag_sync_logs/logs/log_api_calls';

    /** @var string */
    public const XML_PATH_LOG_ROTATION_DELAY = 'fastmag_sync_logs/logs/rotation_delay';
}
