<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-04-29
 ******************************************************************************/

namespace Fastmag\Sync\Model\Config\Source\Rule;

use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class StockAlgorithms
 *
 * Source for stock calculation algorithms
 */
class StockAlgorithms implements OptionSourceInterface
{
    /**
     * @inheritDoc
     */
    public function toOptionArray()
    {
        return [
            ['value' => 'real', 'label' => __('Real inventory: registered')],
            ['value' => 'immediate', 'label' => __('Immediate inventory: registered - sold')],
            /* @todo > 1.0.0 : add more inventory algorithm types */
            //['value' => 'theoretical', 'label' => __('Theoretical inventory: registered + waiting + manufacturer - sold')],
            //['value' => 'logistic', 'label' => __('Logistic inventory: registered + reserved + not shippable')]
        ];
    }

    /**
     * Returns values as associative array
     *
     * @return array
     */
    public function toArray()
    {
        return [
            'real' => __('Real inventory: registered'),
            'immediate' => __('Immediate inventory: registered - sold'),
            /* @todo > 1.0.0 : add more inventory algorithm types */
            //'theoretical' => __('Theoretical inventory: registered + waiting + manufacturer - sold'),
            //'logistic' => __('Logistic inventory: registered + reserved + not shippable')
        ];
    }
}
