<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-09-14
 ******************************************************************************/

namespace Fastmag\Sync\Model;

use Fastmag\Sync\Api\Data\OrderInterface;
use Fastmag\Sync\Model\ResourceModel\Order as ResourceModel;
use Magento\Framework\DataObject\IdentityInterface;
use Magento\Framework\Model\AbstractModel;

/**
 * Class Order
 *
 * Synchronized orders model
 */
class Order extends AbstractModel implements OrderInterface, IdentityInterface
{
    /** @var string */
    public const CACHE_TAG = 'fastmag_sync_order';

    /** @var string $_cacheTag */
    protected $_cacheTag = self::CACHE_TAG;

    /**
     * Order constructor
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(ResourceModel::class);
    }

    /**
     * @inheritDoc
     */
    public function getId()
    {
        return $this->getData(self::ENTITY_ID);
    }

    /**
     * @inheritDoc
     */
    public function getOrderId()
    {
        return $this->getData(self::ORDER_ID);
    }

    /**
     * @inheritDoc
     */
    public function getTransactionId()
    {
        return $this->getData(self::TRANSACTION_ID);
    }

    /**
     * @inheritDoc
     */
    public function getTransactionIdBis()
    {
        return $this->getData(self::TRANSACTION_ID_BIS);
    }

    /**
     * @inheritDoc
     */
    public function getTransactionType()
    {
        return $this->getData(self::TRANSACTION_TYPE);
    }

    /**
     * @inheritDoc
     */
    public function getState()
    {
        return $this->getData(self::STATE);
    }

    /**
     * @inheritDoc
     */
    public function getEdiCsv()
    {
        return $this->getData(self::EDI_CSV);
    }

    /**
     * @inheritDoc
     */
    public function getEdiSerialized()
    {
        return $this->getData(self::EDI_SERIALIZED);
    }

    /**
     * @inheritDoc
     */
    public function getResultLog()
    {
        return $this->getData(self::RESULT_LOG);
    }

    /**
     * @inheritDoc
     */
    public function getRequestAt()
    {
        return $this->getData(self::REQUEST_AT);
    }

    /**
     * @inheritDoc
     */
    public function getResultAt()
    {
        return $this->getData(self::RESULT_AT);
    }

    /**
     * @inheritDoc
     */
    public function getOriginShop()
    {
        return $this->getData(self::ORIGIN_SHOP);
    }

    /**
     * @inheritDoc
     */
    public function getTargetShop()
    {
        return $this->getData(self::TARGET_SHOP);
    }

    /**
     * @inheritDoc
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId()];
    }

    /**
     * @inheritDoc
     */
    public function setId($orderId)
    {
        return $this->setData(self::ENTITY_ID, $orderId);
    }

    /**
     * @inheritDoc
     */
    public function setOrderId($orderId)
    {
        return $this->setData(self::ORDER_ID, $orderId);
    }

    /**
     * @inheritDoc
     */
    public function setTransactionId($transactionId)
    {
        return  $this->setData(self::TRANSACTION_ID, $transactionId);
    }

    /**
     * @inheritDoc
     */
    public function setTransactionIdBis($transactionIdBis)
    {
        return $this->setData(self::TRANSACTION_ID_BIS, $transactionIdBis);
    }

    /**
     * @inheritDoc
     */
    public function setTransactionType($type)
    {
        return $this->setData(self::TRANSACTION_TYPE, $type);
    }

    /**
     * @inheritDoc
     */
    public function setState($state)
    {
        return $this->setData(self::STATE, $state);
    }

    /**
     * @inheritDoc
     */
    public function setEdiCsv($ediCsv)
    {
        return $this->setData(self::EDI_CSV, $ediCsv);
    }

    /**
     * @inheritDoc
     */
    public function setEdiSerialized($ediSerialized)
    {
        return $this->setData(self::EDI_SERIALIZED, $ediSerialized);
    }

    /**
     * @inheritDoc
     */
    public function setResultLog($resultLog)
    {
        return $this->setData(self::RESULT_LOG, $resultLog);
    }

    /**
     * @inheritDoc
     */
    public function setRequestAt($requestAt)
    {
        return $this->setData(self::REQUEST_AT, $requestAt);
    }

    /**
     * @inheritDoc
     */
    public function setResultAt($resultAt)
    {
        return $this->setData(self::RESULT_AT, $resultAt);
    }

    /**
     * @inheritDoc
     */
    public function setOriginShop($originShop)
    {
        return $this->setData(self::ORIGIN_SHOP, $originShop);
    }

    /**
     * @inheritDoc
     */
    public function setTargetShop($targetShop)
    {
        return $this->setData(self::TARGET_SHOP, $targetShop);
    }
}
