<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-06-08
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker\RemoteSync;

use DateInterval;
use DateTime;
use Exception;
use Fastmag\Sync\Exception\NoConnectionException;
use Fastmag\Sync\Process\Worker;
use Magento\Framework\DB\Adapter\Pdo\Mysql;

/**
 * Class Clean
 *
 * Worker class used for cleaning obsolete lines from queue table in Fastmag DB
 */
class Clean extends Worker
{
    /** @inheritDoc */
    protected $code = 'remotesync_clean';

    /**
     * @inheritDoc
     */
    public function run()
    {
        try {
            $now = new DateTime();
            $lastCleaningDate = $this->getLastExecutionDate();

            if ($lastCleaningDate->format(Mysql::DATE_FORMAT) === '1970-01-01') {
                $lastCleaningDate = new DateTime();
                $lastCleaningDate->sub(new DateInterval('PT14H'));
            } else {
                $lastCleaningDate->add(new DateInterval('PT12H'));
            }
        } catch (Exception $e) {
            return;
        }

        if ($now > $lastCleaningDate) {
            $this->logger->debug(
                'Clean old events twice a day - ' . $lastCleaningDate->format(Mysql::DATETIME_FORMAT)
            );

            $query = 'DELETE FROM fmsync_job_queue
                WHERE date_maj < \'' . $lastCleaningDate->format(Mysql::DATE_FORMAT) . '\'';

            $this->logger->debug($query);

            try {
                $result = $this->getFastmagSqlConnection()->post($query);

                if ($result) {
                    $this->setLastExecutionDate();
                }
            } catch (NoConnectionException $e) {
                $this->logger->alert('Unable to connect with Fastmag database.' . $e->getMessage());
            }
        }
    }
}
