<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-06-08
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker\ToMagento;

use Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface as Job;
use Fastmag\Sync\Model\ResourceModel\Jobqueue\ToMagento\Collection;
use Fastmag\Sync\Process\EntityInterface;
use Fastmag\Sync\Process\Worker\Hydration as AbstractHydration;

/**
 * Class Hydration
 *
 * Abstract class inherited by all ToMagento hydration workers
 *
 * @property Collection $jobs
 */
abstract class Hydration extends AbstractHydration
{
    /**
     * Run the queries to Fastmag through EDI or Direct SQL and returns the data as an array
     *
     * @return array
     */
    abstract protected function getDataFromFastmag();

    /**
     * Store temporarily the hydrated data as entities linked to the current job
     *
     * @param EntityInterface $entity
     * @param int             $jobId
     *
     * @return void
     */
    protected function setEntity($entity, $jobId)
    {
        $job = $this->jobs->getItemByColumnValue(Job::JOB_ID, $jobId);

        if ($job) {
            $job->setEntity($entity);
        }
    }
}
