<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-12-15
 ******************************************************************************/

namespace Fastmag\Sync\Ui\Component\Listing\Column\Rule;

use Magento\Directory\Model\CountryFactory;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Ui\Component\Listing\Columns\Column;

/**
 * Class CountriesTitle
 *
 * Column renderer for allowed countries
 */
class CountriesTitle extends Column
{
    /** @var CountryFactory  */
    private $countryFactory;

    /**
     * CountriesTitle constructor
     *
     * @param ContextInterface     $context
     * @param UiComponentFactory   $uiComponentFactory
     * @param CountryFactory       $countryFactory
     * @param array                $components
     * @param array                $data
     */
    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        CountryFactory $countryFactory,
        array $components = [],
        array $data = []
    ) {
        parent::__construct($context, $uiComponentFactory, $components, $data);
        $this->_countryFactory = $countryFactory;
    }

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     *
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                $item[$this->getData('name')] = $this->prepareItem($item);
            }
        }

        return $dataSource;
    }

    /**
     * Get data
     *
     * @param array $item
     *
     * @return string
     */
    protected function prepareItem(array $item)
    {
        $code = $item['allowed_countries'];
        $content = $code;

        if ($code != '') {
            $AllCodes = explode(',', $code);
            $newcontent = [];
            foreach ($AllCodes as $code) {
                $country = $this->_countryFactory->create()->loadByCode($code);
                $newcontent[] = $country->getName();
            }
            $content = implode(',', $newcontent);
        }

        return $content;
    }
}
