<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-08-17
 ******************************************************************************/

namespace Fastmag\Sync\Block\Adminhtml\Preconfig;

use Fastmag\Sync\Model\System\Connection\Edi\Config;
use Magento\Backend\Block\Template;
use Magento\Backend\Block\Template\Context;

/**
 * Class Form
 *
 * Block class for form element on preconfig page
 */
class Form extends Template
{
    /** @var Config $ediCconfig */
    protected $ediConfig;

    /**
     * Form constructor.
     *
     * @param Context $context
     * @param Config  $ediConfig
     * @param array   $data
     */
    public function __construct(Context $context, Config $ediConfig, array $data = [])
    {
        parent::__construct($context, $data);

        $this->ediConfig = $ediConfig;
    }

    /**
     * Returns data source (given by config field)
     *
     * @return string
     */
    public function getDataSource()
    {
        return $this->ediConfig->getDataSource();
    }
}
