<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-04-29
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\Rule;

use Fastmag\Sync\Api\Rule\OrdertransactionRepositoryInterface;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Page;
use Magento\Framework\App\Request\DataPersistorInterface;

/**
 * Class Ordertransaction
 */
abstract class Ordertransaction extends Action
{
    /** @var string */
    public const ADMIN_RESOURCE = 'Fastmag_Sync::order_transaction';

    /** @var DataPersistorInterface $dataPersistor */
    protected $dataPersistor;

    /** @var OrdertransactionRepositoryInterface $ruleRepository */
    protected $ruleRepository;

    /**
     * Ordertransaction constructor
     *
     * @param Context                             $context
     * @param DataPersistorInterface              $dataPersistor
     * @param OrdertransactionRepositoryInterface $ruleRepository
     */
    public function __construct(
        Context $context,
        DataPersistorInterface $dataPersistor,
        OrdertransactionRepositoryInterface $ruleRepository
    ) {
        parent::__construct($context);

        $this->dataPersistor = $dataPersistor;
        $this->ruleRepository = $ruleRepository;
    }

    /**
     * Init page
     *
     * @param Page $resultPage
     *
     * @return Page
     */
    protected function initPage($resultPage)
    {
        $resultPage->setActiveMenu('Fastmag_Sync::fastmag_sync_rule_ordertransaction')
            ->addBreadcrumb(__('Rules'), __('Rules'))
            ->addBreadcrumb(__('Order/Transaction'), __('Order/Transaction'));

        return $resultPage;
    }
}
