<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-04-29
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\Rule\Storeseller;

use Exception;
use Fastmag\Sync\Controller\Adminhtml\Rule\Storeseller as ControllerAbstract;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\Controller\ResultInterface;

/**
 * Class Delete
 *
 * Storeseller delete action
 *
 * @todo change architecture to avoid code duplication
 */
class Delete extends ControllerAbstract implements HttpPostActionInterface
{
    /**
     * Delete action
     *
     * @return ResultInterface
     */
    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();
        $ruleId = $this->getRequest()->getParam('id');

        if ($ruleId) {
            try {
                $rule = $this->ruleRepository->getById($ruleId);
                $this->ruleRepository->delete($rule);

                $this->messageManager->addSuccessMessage(__('You deleted the rule.'));
                return $resultRedirect->setPath('*/*/');
            } catch (Exception $e) {
                $this->messageManager->addErrorMessage($e->getMessage());
                return $resultRedirect->setPath('*/*/edit', ['id' => $ruleId]);
            }
        }

        $this->messageManager->addErrorMessage(__('We can\'t find a rule to delete.'));
        return $resultRedirect->setPath('*/*/');
    }
}
