<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-06-30
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\System\Config\Connection;

use Fastmag\Sync\Exception\NoConnectionException;
use Fastmag\Sync\Model\System\Connection\Sql\DirectSql as ProxyConnector;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;

/**
 * Class Proxy
 *
 * Proxy connection test action
 */
class Proxy extends Action
{
    /** @var string */
    public const ADMIN_RESOURCE = 'Fastmag_Sync::config';

    /** @var JsonFactory $resultJsonFactory */
    protected $resultJsonFactory;

    /** @var ProxyConnector $proxyConnector */
    protected $proxyConnector;

    /**
     * Edi constructor
     *
     * @param Context        $context
     * @param JsonFactory    $resultJsonFactory
     * @param ProxyConnector $proxyConnector
     */
    public function __construct(
        Context $context,
        JsonFactory $resultJsonFactory,
        ProxyConnector $proxyConnector
    ) {
        parent::__construct($context);

        $this->resultJsonFactory = $resultJsonFactory;
        $this->proxyConnector = $proxyConnector;
    }

    /**
     * @inheritDoc
     */
    public function execute()
    {
        $result = ['test_connect' => 0];

        $host = $this->getRequest()->getParam('host');
        $port = $this->getRequest()->getParam('port');
        $username = $this->getRequest()->getParam('user');
        $password = $this->getRequest()->getParam('password');

        try {
            $result['test_connect'] = (int) $this->proxyConnector
                ->setCredentials($host, $port, $username, $password)
                ->connect();
        } catch (NoConnectionException $e) {
            $result['message'] = __('Code: %1 - Error: %2', $e->getCode(), $e->getMessage());
        }

        $resultJson = $this->resultJsonFactory->create();

        return $resultJson->setData($result);
    }
}
