<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-09-16
 ******************************************************************************/

namespace Fastmag\Sync\Observer;

use Fastmag\Sync\Model\Constants;
use Magento\Catalog\Model\Product;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Quote\Model\Quote\Item;

/**
 * Class SetFastmagAttributesQuoteItem
 *
 * Observer adding the Fastmag attributes to the quote item when a product is added to the quote
 */
class SetFastmagAttributesQuoteItem implements ObserverInterface
{
    /**
     * @inheritDoc
     */
    public function execute(Observer $observer)
    {
        /** @var Item $quoteItem */
        $quoteItem = $observer->getQuoteItem();
        /** @var Product $product */
        $product = $observer->getProduct();

        $quoteItem->setCustomAttribute(
            Constants::ATTRIBUTE_QUOTE_FASTMAG_PRODUCT_ID_CODE,
            $product->getAttributeText(Constants::ATTRIBUTE_PRODUCT_FASTMAG_PRODUCT_ID_CODE)
        );
    }
}
