<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-06-10
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker\ToMagento;

use Fastmag\Sync\Api\Jobqueue\ToMagentoRepositoryInterface as JobRepository;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\ResourceModel\Jobqueue\ToMagento\Collection;
use Fastmag\Sync\Model\System\Connection\Proxy as FastmagSql;
use Fastmag\Sync\Process\Worker\Integration as AbstractIntegration;
use Magento\Framework\App\ResourceConnection;

/**
 * Class Integration
 *
 * Abstract class inherited by all integration workers
 *
 * @property Collection $jobs
 */
abstract class Integration extends AbstractIntegration
{
    /** @var JobRepository $jobRepository */
    protected $jobRepository;

    /**
     * Customer constructor.
     *
     * @param Logger             $logger
     * @param ResourceConnection $resourceConnection
     * @param FastmagSql         $fastmagSql
     * @param Config             $config
     * @param JobRepository      $jobRepository
     */
    public function __construct(
        Logger $logger,
        ResourceConnection $resourceConnection,
        FastmagSql $fastmagSql,
        Config $config,
        JobRepository $jobRepository
    ) {
        parent::__construct($logger, $resourceConnection, $fastmagSql, $config);

        $this->jobRepository = $jobRepository;
    }
}
