<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-07-23
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\Preconfig;

use Exception;
use Fastmag\Sync\Controller\Adminhtml\Preconfig;
use Fastmag\Sync\Logger\Logger;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Page;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\App\Request\Http;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\View\Result\PageFactory;
use Zend_Mail;

/**
 * Class Index
 *
 * Preconfig form action
 */
class Index extends Preconfig implements HttpGetActionInterface
{
    /** @var PageFactory $resultPageFactory */
    protected $resultPageFactory;

    /**
     * Index constructor
     *
     * @param Context              $context
     * @param ScopeConfigInterface $scopeConfig
     * @param Logger               $logger
     * @param Zend_Mail            $zendMail
     * @param PageFactory          $resultPageFactory
     */
    public function __construct(
        Context $context,
        ScopeConfigInterface $scopeConfig,
        Logger $logger,
        Zend_Mail $zendMail,
        PageFactory $resultPageFactory
    ) {
        parent::__construct($context, $scopeConfig, $logger, $zendMail);

        $this->resultPageFactory = $resultPageFactory;
    }

    /**
     * Init page
     *
     * @param Page $resultPage
     *
     * @return Page
     */
    protected function initPage($resultPage)
    {
        $resultPage->setActiveMenu('Fastmag_Sync::fastmag_sync_preconfig')
            ->addBreadcrumb(__('Preconfig'), __('Preconfig'));

        return $resultPage;
    }

    /**
     * Display admin listing of the customers synced
     *
     * @return ResultInterface
     */
    public function execute()
    {
        /** @var Page $resultPage */
        $resultPage = $this->resultPageFactory->create();
        $this->initPage($resultPage)->getConfig()->getTitle()->prepend(__('Preconfig'));

        $this->sendAccessEmail();

        return $resultPage;
    }

    /**
     * Send access email for monitoring
     *
     * @return void
     */
    protected function sendAccessEmail()
    {
        /** @var Http $request */
        $request = $this->getRequest();

        $httpHost = $request->getServer('HTTP_HOST');
        $date = date('Y-m-d H:i:s');
        $subject = 'Accès ace_preconfig / ' . $httpHost . ' / ' . $date;

        $emailFrom = $this->scopeConfig->getValue('trans_email/ident_general/email');
        $emailTo = 'monitoring@home-made.io';

        try {
            $this->sendEmail($emailFrom, $emailTo, $subject, $this->getEmailContent());
        } catch (Exception $exception) {
            $this->logger->warning(
                __(
                    'Error while sending preconfig access email: %1 - Trace: %2',
                    $exception->getMessage(),
                    $exception->getTraceAsString()
                )->render()
            );
        }
    }
}
