<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-06-24
 ******************************************************************************/

namespace Fastmag\Sync\FastmagSetup;

/**
 * Class Installer
 *
 * Class handling job queue and triggers installations on Fastmag
 */
class Installer
{
    /** @var string */
    const CMS_CODE = 'magento2';

    /** @var string[] */
    protected $sql = ['triggers' => [], 'tables' => []];

    /**
     * Get installation queries
     *
     * @return array
     */
    public function getInstallQueries()
    {
        $this->sql['tables']['fmsync_job_queue'] = '
            CREATE TABLE IF NOT EXISTS fmsync_job_queue (
                id_job INT(10) NOT NULL AUTO_INCREMENT,
                identifiant VARCHAR(60) DEFAULT NULL,
                job VARCHAR(20) DEFAULT NULL,
                code_mag VARCHAR(30) DEFAULT NULL,
                date_creation DATETIME NOT NULL,
                date_maj DATETIME DEFAULT NULL,
                date_a_traiter DATETIME DEFAULT NULL,
                commentaire LONGTEXT DEFAULT NULL,
                priorite BIGINT(8) UNSIGNED NOT NULL DEFAULT 0,
                checksum VARCHAR(100) DEFAULT \'\',
                PRIMARY KEY(id_job),
                INDEX(job),
                INDEX(identifiant),
                INDEX(code_mag),
                INDEX(date_a_traiter),
                UNIQUE KEY index_job_queue_unique (job, identifiant, checksum)
            ) ENGINE=MYISAM DEFAULT CHARSET=utf8;';

        $this->setProductsTriggers();
        $this->setProductsImagesTriggers();
        $this->setProductsPricesTriggers();
        $this->setProductsInventoryTriggers();
        $this->setOrdersTriggers();

        return $this->sql;
    }

    /**
     * Get products related triggers
     *
     * @return void
     */
    protected function setProductsTriggers()
    {
        // produitsfiches
        $this->sql['triggers']['trigger_fmsync_produitsfiches_update'] = '
            CREATE TRIGGER trigger_fmsync_produitsfiches_update
                AFTER UPDATE
                ON produitsfiches
                FOR EACH ROW
            BEGIN
                INSERT INTO fmsync_job_queue
                SET identifiant   = NEW.BarCode,
                    job           = \'ProductCreate\',
                    commentaire   = JSON_OBJECT(
                        \'trigger\', \'trigger_fmsync_produitsfiches_update\',
                        \'cms\', \'' . self::CMS_CODE . '\'
                    ),
                    date_creation = NOW(),
                    date_maj      = NOW()
                ON DUPLICATE KEY UPDATE date_maj = NOW();
            END;';

        // produitslangues
        $this->sql['triggers']['trigger_fmsync_produitslangues_update'] = '
            CREATE TRIGGER trigger_fmsync_produitslangues_update
                AFTER UPDATE
                ON produitslangues
                FOR EACH ROW
            BEGIN
                INSERT INTO fmsync_job_queue
                SET identifiant   = NEW.BarCode,
                    job           = \'ProductCreate\',
                    commentaire   = JSON_OBJECT(
                        \'trigger\', \'trigger_fmsync_produitslangues_update\',
                        \'cms\', \'' . self::CMS_CODE . '\'
                    ),
                    date_creation = NOW(),
                    date_maj      = NOW()
                ON DUPLICATE KEY UPDATE date_maj = NOW();
            END;';

        // produits
        $this->sql['triggers']['trigger_fmsync_produits_update'] = '
            CREATE TRIGGER trigger_fmsync_produits_update
                AFTER UPDATE
                ON produits
                FOR EACH ROW
            BEGIN
                INSERT INTO fmsync_job_queue
                SET identifiant   = NEW.BarCode,
                    job           = \'ProductCreate\',
                    commentaire   = JSON_OBJECT(
                        \'trigger\', \'trigger_fmsync_produits_update\', 
                        \'cms\', \'' . self::CMS_CODE . '\'
                    ),
                    date_creation = NOW(),
                    date_maj      = NOW()
                ON DUPLICATE KEY UPDATE date_maj = NOW();
            END;';

        // produitstarifs
        $this->sql['triggers']['trigger_fmsync_produitstarifs_insert'] = '
            CREATE TRIGGER trigger_fmsync_produitstarifs_insert
                AFTER INSERT
                ON produitstarifs
                FOR EACH ROW
            BEGIN
                INSERT INTO fmsync_job_queue
                SET identifiant   = NEW.BarCode,
                    job           = \'ProductCreate\',
                    commentaire   = JSON_OBJECT(
                        \'trigger\', \'trigger_fmsync_produitstarifs_insert\',
                        \'cms\', \'' . self::CMS_CODE . '\'
                    ),
                    date_creation = NOW(),
                    date_maj      = NOW()
                ON DUPLICATE KEY UPDATE date_maj = NOW();
            END;';

        $this->sql['triggers']['trigger_fmsync_produitstarifs_update'] = '
            CREATE TRIGGER trigger_fmsync_produitstarifs_update
                AFTER UPDATE
                ON produitstarifs
                FOR EACH ROW
            BEGIN
                INSERT INTO fmsync_job_queue
                SET identifiant   = NEW.BarCode,
                    job           = \'ProductCreate\',
                    commentaire   = JSON_OBJECT(
                        \'trigger\', \'trigger_fmsync_produitstarifs_update\',
                        \'cms\', \'' . self::CMS_CODE . '\'
                    ),
                    date_creation = NOW(),
                    date_maj      = NOW()
                ON DUPLICATE KEY UPDATE date_maj = NOW();
            END;';

        $this->sql['triggers']['trigger_fmsync_produitstarifs_delete'] = '
            CREATE TRIGGER trigger_fmsync_produitstarifs_delete
                AFTER DELETE
                ON produitstarifs
                FOR EACH ROW
            BEGIN
                INSERT INTO fmsync_job_queue
                SET identifiant   = OLD.BarCode,
                    job           = \'ProductCreate\',
                    commentaire   = JSON_OBJECT(
                        \'trigger\', \'trigger_fmsync_produitstarifs_delete\',
                        \'cms\', \'' . self::CMS_CODE . '\'
                    ),
                    date_creation = NOW(),
                    date_maj      = NOW()
                ON DUPLICATE KEY UPDATE date_maj = NOW();
            END;';

        // produitsprixqte
        $sql['triggers']['trigger_fmsync_produits_prixqte_insert'] = '
            CREATE TRIGGER trigger_fmsync_produits_prixqte_insert
                AFTER INSERT
                ON produitsprixqte
                FOR EACH ROW
            BEGIN
                INSERT INTO fmsync_job_queue
                SET priorite      = 10,
                    identifiant   = NEW.BarCode,
                    job           = \'ProductUpdate\',
                    commentaire   = JSON_OBJECT(
                        \'trigger\', \'trigger_fmsync_produits_prixqte_insert\',
                        \'cms\', \'' . self::CMS_CODE . '\',
                        \'prix\', NEW.Prix,
                        \'remise\', NEW.Remise
                    ),
                    date_creation = NOW(),
                    date_maj      = NOW()
                ON DUPLICATE KEY UPDATE date_maj = NOW();
            END;';

        $sql['triggers']['trigger_fmsync_produits_prixqte_update'] = '
            CREATE TRIGGER trigger_fmsync_produits_prixqte_update
                AFTER UPDATE
                ON produitsprixqte
                FOR EACH ROW
            BEGIN
                INSERT INTO fmsync_job_queue
                SET priorite      = 10,
                    identifiant   = NEW.BarCode,
                    job           = \'ProductUpdate\',
                    commentaire   = JSON_OBJECT(
                        \'trigger\', \'trigger_fmsync_produits_prixqte_update\',
                        \'cms\', \'' . self::CMS_CODE . '\',
                        \'prix\', NEW.Prix,
                        \'remise\', NEW.Remise
                    ),
                    date_creation = NOW(),
                    date_maj      = NOW()
                ON DUPLICATE KEY UPDATE date_maj = NOW();
            END;';

        $sql['triggers']['trigger_fmsync_produits_prixqte_delete'] = '
            CREATE TRIGGER trigger_fmsync_produits_prixqte_delete
                AFTER DELETE
                ON produitsprixqte
                FOR EACH ROW
            BEGIN
                INSERT INTO fmsync_job_queue
                SET priorite      = 10,
                    identifiant   = OLD.BarCode,
                    job           = \'ProductUpdate\',
                    commentaire   = JSON_OBJECT(
                        \'trigger\', \'trigger_fmsync_produits_prixqte_delete\',
                        \'cms\', \'' . self::CMS_CODE . '\'
                    ),
                    date_creation = NOW(),
                    date_maj      = NOW()
                ON DUPLICATE KEY UPDATE date_maj = NOW();
            END;';
    }

    /**
     * Get products images related triggers
     *
     * @return void
     */
    protected function setProductsImagesTriggers()
    {
        // produitsfiches
        $this->sql['triggers']['trigger_fmsync_produitsfiches_images_update'] = '
            CREATE TRIGGER trigger_fmsync_produitsfiches_images_update
                AFTER UPDATE
                ON produitsfiches
                FOR EACH ROW
            BEGIN
                IF NEW.DerniereModifPhoto <> OLD.DerniereModifPhoto THEN
                    INSERT INTO fmsync_job_queue
                    SET identifiant   = NEW.BarCode,
                        job           = \'ProductImage\',
                        commentaire   = JSON_OBJECT(
                            \'trigger\', \'trigger_fmsync_produitsfiches_images_update\',
                            \'cms\', \'' . self::CMS_CODE . '\',
                            \'last_image_update\', NEW.DerniereModifPhoto
                        ),
                        date_creation = NOW(),
                        date_maj      = NOW()
                    ON DUPLICATE KEY UPDATE date_maj = NOW();
                END IF;
            END;';
    }

    /**
     * Get products prices related triggers
     *
     * @return void
     */
    protected function setProductsPricesTriggers()
    {
        // prixremise
        $this->sql['triggers']['trigger_fmsync_produits_promo_insert'] = '
            CREATE TRIGGER trigger_fmsync_produits_promo_insert
                AFTER INSERT
                ON prixremise
                FOR EACH ROW
            BEGIN
                INSERT INTO fmsync_job_queue (identifiant, job, commentaire, priorite, date_creation, date_maj)
                SELECT BarCode, 
                        \'ProductSpecialPrice\',
                        JSON_OBJECT(
                            \'trigger\', \'trigger_fmsync_produits_promo_insert\',
                            \'cms\', \'' . self::CMS_CODE . '\',
                            \'code_magasin\', NEW.CodeMag,
                            \'date_debut\', NEW.DateDebut,
                            \'date_fin\', NEW.DateFin,
                            \'prix\', NEW.Prix,
                            \'remise\', NEW.Remise
                        ),
                        80,
                        NOW(),
                        NOW()
                    FROM produitsfiches 
                    WHERE Actif = 1 AND VisibleWeb = 1 AND BarCode = NEW.BarCode
                ON DUPLICATE KEY UPDATE date_maj = NOW();
            
                IF NEW.DateDebut IS NOT NULL AND NEW.DateDebut > NOW() THEN
                    INSERT INTO fmsync_job_queue
                        (identifiant, job, commentaire, priorite, date_creation, date_maj, date_a_traiter, code_mag, checksum)
                    SELECT BarCode,
                            \'ProductSpecialPrice\', 
                            JSON_OBJECT(
                                \'trigger\', \'trigger_fmsync_produits_promo_insert\',
                                \'cms\', \'' . self::CMS_CODE . '\',
                                \'code_magasin\', NEW.CodeMag,
                                \'date_debut\', NEW.DateDebut,
                                \'prix\', NEW.Prix,
                                \'remise\', NEW.Remise
                            ),
                            80 , 
                            NOW(), 
                            NOW(),
                            NEW.DateDebut,
                            NEW.CodeMag,
                            CONCAT(NEW.BarCode, NEW.DateDebut, NEW.CodeMag, \'ProductSpecialPrice\')
                        FROM produitsfiches 
                        WHERE Actif = 1 AND VisibleWeb = 1 AND BarCode = NEW.BarCode
                    ON DUPLICATE KEY UPDATE date_maj = NOW();
                END IF;
            
                IF NEW.DateFin IS NOT NULL AND NEW.DateFin > NOW() THEN
                    INSERT INTO fmsync_job_queue
                        (identifiant, job, commentaire, priorite, date_creation, date_maj, date_a_traiter, code_mag, checksum)
                    SELECT BarCode, 
                            \'ProductSpecialPrice\', 
                            JSON_OBJECT(
                                \'trigger\', \'trigger_fmsync_produits_promo_insert\',
                                \'cms\', \'' . self::CMS_CODE . '\',
                                \'code_magasin\', NEW.CodeMag,
                                \'date_fin\', NEW.DateFin,
                                \'prix\', NEW.Prix,
                                \'remise\', NEW.Remise
                            ),
                            80 , 
                            NOW(),
                            NOW(),
                            CONCAT(NEW.DateFin, \' 23:59:59\'),
                            NEW.CodeMag,
                            CONCAT(NEW.BarCode, NEW.DateFin, NEW.CodeMag, \'ProductSpecialPrice\')
                        FROM produitsfiches 
                        WHERE Actif = 1 AND VisibleWeb = 1 AND BarCode = NEW.BarCode 
                    ON DUPLICATE KEY UPDATE date_maj = NOW();
                END IF;
            END;';

        $this->sql['triggers']['trigger_fmsync_produits_promo_update'] = '
            CREATE TRIGGER trigger_fmsync_produits_promo_update
                AFTER UPDATE
                ON prixremise
                FOR EACH ROW
            BEGIN
                INSERT INTO fmsync_job_queue (identifiant, job, commentaire, priorite, date_creation, date_maj)
                SELECT BarCode,
                        \'ProductSpecialPrice\',
                        JSON_OBJECT(
                            \'trigger\', \'trigger_fmsync_produits_promo_update\',
                            \'cms\', \'' . self::CMS_CODE . '\',
                            \'code_magasin\', NEW.CodeMag,
                            \'date_debut\', NEW.DateDebut,
                            \'date_fin\', NEW.DateFin,
                            \'prix\', NEW.Prix,
                            \'remise\', NEW.Remise
                        ),
                        80,
                        NOW(), 
                        NOW()
                    FROM produitsfiches 
                    WHERE Actif = 1 AND VisibleWeb = 1 AND BarCode = NEW.BarCode
                ON DUPLICATE KEY UPDATE date_maj = NOW();
            
                IF NEW.DateDebut IS NOT NULL AND NEW.DateDebut > NOW() THEN
                    INSERT INTO fmsync_job_queue
                        (identifiant, job, commentaire, priorite, date_creation, date_maj, date_a_traiter, code_mag, checksum)
                    SELECT BarCode,
                            \'ProductSpecialPrice\', 
                            JSON_OBJECT(
                                \'trigger\', \'trigger_fmsync_produits_promo_update\',
                                \'cms\', \'' . self::CMS_CODE . '\',
                                \'code_magasin\', NEW.CodeMag,
                                \'date_debut\', NEW.DateDebut,
                                \'prix\', NEW.Prix,
                                \'remise\', NEW.Remise
                            ),
                            80 , 
                            NOW(), 
                            NOW(),
                            NEW.DateDebut,
                            NEW.CodeMag,
                            CONCAT(NEW.BarCode, NEW.DateDebut, NEW.CodeMag, \'ProductSpecialPrice\')
                        FROM produitsfiches 
                        WHERE Actif = 1 AND VisibleWeb = 1 AND BarCode = NEW.BarCode
                    ON DUPLICATE KEY UPDATE date_maj = NOW();
                END IF;
            
                IF NEW.DateFin IS NOT NULL AND NEW.DateFin > NOW() THEN
                    INSERT INTO fmsync_job_queue
                        (identifiant, job, commentaire, priorite, date_creation, date_maj, date_a_traiter, code_mag, checksum)
                    SELECT BarCode, 
                            \'ProductSpecialPrice\', 
                            JSON_OBJECT(
                                \'trigger\', \'trigger_fmsync_produits_promo_update\',
                                \'cms\', \'' . self::CMS_CODE . '\',
                                \'code_magasin\', NEW.CodeMag,
                                \'date_fin\', NEW.DateFin,
                                \'prix\', NEW.Prix,
                                \'remise\', NEW.Remise
                            ),
                            80, 
                            NOW(),
                            NOW(),
                            CONCAT(NEW.DateFin, \' 23:59:59\'),
                            NEW.CodeMag,
                            CONCAT(NEW.BarCode, NEW.DateFin, NEW.CodeMag, \'ProductSpecialPrice\')
                        FROM produitsfiches 
                        WHERE Actif = 1 AND VisibleWeb = 1 AND BarCode = NEW.BarCode 
                    ON DUPLICATE KEY UPDATE date_maj = NOW();
                END IF;
            END;';

        $this->sql['triggers']['trigger_fmsync_produits_promo_delete'] = '
            CREATE TRIGGER trigger_fmsync_produits_promo_delete
                AFTER DELETE
                ON prixremise
                FOR EACH ROW
            BEGIN
                INSERT INTO fmsync_job_queue (identifiant, job, commentaire, priorite, date_creation, date_maj)
                SELECT BarCode,
                        \'ProductSpecialPrice\', 
                        JSON_OBJECT(
                            \'trigger\', \'trigger_fmsync_produits_promo_delete\',
                            \'cms\', \'' . self::CMS_CODE . '\'
                        ),
                        80,
                        NOW(),
                        NOW() 
                    FROM produitsfiches 
                    WHERE Actif = 1 AND VisibleWeb = 1 AND BarCode = OLD.BarCode
                ON DUPLICATE KEY UPDATE date_maj = NOW();
            END;';

        // prixremisetc
        $this->sql['triggers']['trigger_fmsync_produits_promotc_insert'] = '
            CREATE TRIGGER trigger_fmsync_produits_promotc_insert
                AFTER INSERT
                ON prixremisetc
                FOR EACH ROW
            BEGIN
                INSERT INTO fmsync_job_queue
                SET priorite    = 80,
                    identifiant = NEW.BarCode,
                    job         = \'ProductSpecialPrice\',
                    code_mag    = NEW.CodeMag,
                    commentaire = JSON_OBJECT(
                        \'trigger\', \'trigger_fmsync_produits_promotc_insert\',
                        \'cms\', \'' . self::CMS_CODE . '\',
                        \'code_magasin\', NEW.CodeMag,
                        \'date_debut\', NEW.DateDebut,
                        \'date_fin\', NEW.DateFin,
                        \'prix\', NEW.Prix,
                        \'remise\', NEW.Remise
                    ),
                    date_creation = NOW(),
                    date_maj      = NOW()
                ON DUPLICATE KEY UPDATE date_maj = NOW();
            
                IF NEW.DateDebut IS NOT NULL AND NEW.DateDebut > NOW() THEN
                    INSERT INTO fmsync_job_queue
                    SET identifiant    = NEW.BarCode,
                        date_a_traiter = NEW.DateDebut,
                        job            = \'ProductSpecialPrice\',
                        code_mag       = NEW.CodeMag,
                        commentaire    = JSON_OBJECT(
                            \'trigger\', \'trigger_fmsync_produits_promotc_insert\',
                            \'cms\', \'' . self::CMS_CODE . '\',
                            \'code_magasin\', NEW.CodeMag,
                            \'date_debut\', NEW.DateDebut,
                            \'prix\', NEW.Prix,
                            \'remise\', NEW.Remise
                        ),
                        date_creation  = NOW(),
                        date_maj       = NOW(),
                        checksum       = CONCAT(NEW.BarCode, NEW.DateDebut, NEW.CodeMag, \'ProductSpecialPrice\')
                    ON DUPLICATE KEY UPDATE date_maj = NOW();
                END IF;
            
                IF NEW.DateFin IS NOT NULL AND NEW.DateFin > NOW() THEN
                    INSERT INTO fmsync_job_queue
                    SET identifiant    = NEW.BarCode,
                        date_a_traiter = CONCAT(NEW.DateFin, \' 23:59:59\'),
                        job            = \'ProductSpecialPrice\',
                        code_mag       = NEW.CodeMag,
                        commentaire    = JSON_OBJECT(
                            \'trigger\', \'trigger_fmsync_produits_promotc_insert\',
                            \'cms\', \'' . self::CMS_CODE . '\',
                            \'code_magasin\', NEW.CodeMag,
                            \'date_fin\', NEW.DateFin,
                            \'prix\', NEW.Prix,
                            \'remise\', NEW.Remise
                        ),
                        date_creation  = NOW(),
                        date_maj       = NOW(),
                        checksum       = CONCAT(NEW.BarCode, NEW.DateFin, NEW.CodeMag, \'ProductSpecialPrice\')
                    ON DUPLICATE KEY UPDATE date_maj = NOW();
                END IF;
            END;';

        $this->sql['triggers']['trigger_fmsync_produits_promotc_update'] = '
            CREATE TRIGGER trigger_fmsync_produits_promotc_update
                AFTER UPDATE
                ON prixremisetc
                FOR EACH ROW
            BEGIN
                INSERT INTO fmsync_job_queue
                SET priorite    = 80,
                    identifiant = NEW.BarCode,
                    job         = \'ProductSpecialPrice\',
                    code_mag    = NEW.CodeMag,
                    commentaire = JSON_OBJECT(
                        \'trigger\', \'trigger_fmsync_produits_promotc_update\',
                        \'cms\', \'' . self::CMS_CODE . '\',
                        \'code_magasin\', NEW.CodeMag,
                        \'date_debut\', NEW.DateDebut,
                        \'date_fin\', NEW.DateFin,
                        \'prix\', NEW.Prix,
                        \'remise\', NEW.Remise
                    ),
                    date_creation = NOW(),
                    date_maj      = NOW()
                ON DUPLICATE KEY UPDATE date_maj = NOW();
            
                IF NEW.DateDebut IS NOT NULL AND NEW.DateDebut > NOW() THEN
                    INSERT INTO fmsync_job_queue
                    SET identifiant    = NEW.BarCode,
                        date_a_traiter = NEW.DateDebut,
                        job            = \'ProductSpecialPrice\',
                        code_mag       = NEW.CodeMag,
                        commentaire    = JSON_OBJECT(
                            \'trigger\', \'trigger_fmsync_produits_promotc_update\',
                            \'cms\', \'' . self::CMS_CODE . '\',
                            \'code_magasin\', NEW.CodeMag,
                            \'date_debut\', NEW.DateDebut,
                            \'prix\', NEW.Prix,
                            \'remise\', NEW.Remise
                        ),
                        date_creation  = NOW(),
                        date_maj       = NOW(),
                        checksum       = CONCAT(NEW.BarCode, NEW.DateDebut, NEW.CodeMag, \'ProductSpecialPrice\')
                    ON DUPLICATE KEY UPDATE date_maj = NOW();
                END IF;
            
                IF NEW.DateFin IS NOT NULL AND NEW.DateFin > NOW() THEN
                    INSERT INTO fmsync_job_queue
                    SET identifiant    = NEW.BarCode,
                        date_a_traiter = CONCAT(NEW.DateFin, \' 23:59:59\'),
                        job            = \'ProductSpecialPrice\',
                        code_mag       = NEW.CodeMag,
                        commentaire    = JSON_OBJECT(
                            \'trigger\', \'trigger_fmsync_produits_promotc_update\',
                            \'cms\', \'' . self::CMS_CODE . '\',
                            \'code_magasin\', NEW.CodeMag,
                            \'date_fin\', NEW.DateFin,
                            \'prix\', NEW.Prix,
                            \'remise\', NEW.Remise
                        ),
                        date_creation  = NOW(),
                        date_maj       = NOW(),
                        checksum       = CONCAT(NEW.BarCode, NEW.DateFin, NEW.CodeMag, \'ProductSpecialPrice\')
                    ON DUPLICATE KEY UPDATE date_maj = NOW();
                END IF;
            END;';

        $this->sql['triggers']['trigger_fmsync_produits_promotc_delete'] = '
            CREATE TRIGGER trigger_fmsync_produits_promotc_delete
                AFTER DELETE
                ON prixremisetc
                FOR EACH ROW
            BEGIN
                INSERT INTO fmsync_job_queue (identifiant, job, commentaire, priorite, date_creation, date_maj)
                SELECT BarCode,
                        \'ProductSpecialPrice\', 
                        JSON_OBJECT(
                            \'trigger\', \'trigger_fmsync_produits_promotc_delete\',
                            \'cms\', \'' . self::CMS_CODE . '\'
                        ),
                        80,
                        NOW(),
                        NOW() 
                    FROM produitsfiches 
                    WHERE Actif = 1 AND VisibleWeb = 1 AND BarCode = OLD.BarCode
                ON DUPLICATE KEY UPDATE date_maj = NOW();
            END;';
    }

    /**
     * Get products inventory related triggers
     *
     * @return void
     */
    protected function setProductsInventoryTriggers()
    {
        // imagestocks
        $this->sql['triggers']['trigger_fmsync_produits_image_stock_insert'] = '
            CREATE TRIGGER trigger_fmsync_produits_image_stock_insert
                AFTER INSERT
                ON imagestocks
                FOR EACH ROW
            BEGIN
                INSERT INTO fmsync_job_queue
                SET priorite      = 100,
                    identifiant   = NEW.BarCode,
                    job           = \'ProductQuantity\',
                    commentaire   = JSON_OBJECT(
                        \'trigger\', \'trigger_fmsync_produits_image_stock_insert\',
                        \'cms\', \'' . self::CMS_CODE . '\',
                        \'code_magasin\', NEW.CodeMag,
                        \'couleur\', NEW.Couleur,
                        \'taille\', NEW.Taille,
                        \'stock\', NEW.Stock
                    ),
                    date_creation = NOW(),
                    date_maj      = NOW()
                ON DUPLICATE KEY UPDATE date_maj = NOW();
            END;';

        $this->sql['triggers']['trigger_fmsync_produits_image_stock_update'] = '
            CREATE TRIGGER trigger_fmsync_produits_image_stock_update
                AFTER UPDATE
                ON imagestocks
                FOR EACH ROW
            BEGIN
                INSERT INTO fmsync_job_queue
                SET priorite      = 100,
                    identifiant   = NEW.BarCode,
                    job           = \'ProductQuantity\',
                    commentaire   = JSON_OBJECT(
                        \'trigger\', \'trigger_fmsync_produits_image_stock_update\',
                        \'cms\', \'' . self::CMS_CODE . '\',
                        \'code_magasin\', NEW.CodeMag,
                        \'couleur\', NEW.Couleur,
                        \'taille\', NEW.Taille,
                        \'stock\', NEW.Stock
                    ),
                    date_creation = NOW(),
                    date_maj      = NOW()
                ON DUPLICATE KEY UPDATE date_maj = NOW();
            END;';

        $this->sql['triggers']['trigger_fmsync_produits_image_stock_delete'] = '
            CREATE TRIGGER trigger_fmsync_produits_image_stock_delete
                AFTER DELETE
                ON imagestocks
                FOR EACH ROW
            BEGIN
                INSERT INTO fmsync_job_queue
                SET priorite      = 100,
                    identifiant   = OLD.BarCode,
                    job           = \'ProductQuantity\',
                    commentaire   = JSON_OBJECT(
                        \'trigger\', \'trigger_fmsync_produits_image_stock_delete\',
                        \'cms\', \'' . self::CMS_CODE . '\',
                        \'code_magasin\', OLD.CodeMag,
                        \'couleur\', OLD.Couleur,
                        \'taille\', OLD.Taille,
                        \'stock\', OLD.Stock
                    ),
                    date_creation = NOW(),
                    date_maj      = NOW()
                ON DUPLICATE KEY UPDATE date_maj = NOW();
            END;';

        // stocks
        $this->sql['triggers']['trigger_fmsync_produits_stock_insert'] = '
            CREATE TRIGGER trigger_fmsync_produits_stock_insert
                AFTER INSERT
                ON stocks
                FOR EACH ROW
            BEGIN
                INSERT INTO fmsync_job_queue
                SET priorite      = 100,
                    identifiant   = NEW.BarCode,
                    job           = \'ProductQuantity\',
                    commentaire   = JSON_OBJECT(
                        \'trigger\', \'trigger_fmsync_produits_stock_insert\',
                        \'cms\', \'' . self::CMS_CODE . '\',
                        \'code_magasin\', NEW.CodeMag,
                        \'couleur\', NEW.Couleur,
                        \'taille\', NEW.Taille,
                        \'stock\', NEW.Stock
                    ),
                    date_creation = NOW(),
                    date_maj      = NOW()
                ON DUPLICATE KEY UPDATE date_maj = NOW();
            END;';

        $this->sql['triggers']['trigger_fmsync_produits_stock_update'] = '
            CREATE TRIGGER trigger_fmsync_produits_stock_update
                AFTER UPDATE
                ON stocks
                FOR EACH ROW
            BEGIN
                INSERT INTO fmsync_job_queue
                SET priorite      = 100,
                    identifiant   = NEW.BarCode,
                    job           = \'ProductQuantity\',
                    commentaire   = JSON_OBJECT(
                        \'trigger\', \'trigger_fmsync_produits_stock_update\',
                        \'cms\', \'' . self::CMS_CODE . '\',
                        \'code_magasin\', NEW.CodeMag,
                        \'couleur\', NEW.Couleur,
                        \'taille\', NEW.Taille,
                        \'stock\', NEW.Stock
                    ),
                    date_creation = NOW(),
                    date_maj      = NOW()
                ON DUPLICATE KEY UPDATE date_maj = NOW();
            END;';

        // lignes
        $this->sql['triggers']['trigger_fmsync_produits_vente_insert'] = '
            CREATE TRIGGER trigger_fmsync_produits_vente_insert
                AFTER INSERT
                ON lignes
                FOR EACH ROW
            BEGIN
                INSERT INTO fmsync_job_queue
                SET priorite      = 100,
                    identifiant   = NEW.BarCode,
                    job           = \'ProductQuantity\',
                    commentaire   = JSON_OBJECT(
                        \'trigger\', \'trigger_fmsync_produits_vente_insert\',
                        \'cms\', \'' . self::CMS_CODE . '\',
                        \'vente\', NEW.Vente,
                        \'id_stock\', NEW.StockID,
                        \'code_magasin\', NEW.CodeMag,
                        \'couleur\', NEW.Couleur,
                        \'taille\', NEW.Taille,
                        \'quantite\', NEW.Quantite,
                        \'motif\', NEW.Motif
                    ),
                    date_creation = NOW(),
                    date_maj      = NOW()
                ON DUPLICATE KEY UPDATE date_maj = NOW();
            END;';

        $this->sql['triggers']['trigger_fmsync_produits_vente_update'] = '
            CREATE TRIGGER trigger_fmsync_produits_vente_update
                AFTER UPDATE
                ON lignes
                FOR EACH ROW
            BEGIN
                INSERT INTO fmsync_job_queue
                SET priorite      = 100,
                    identifiant   = NEW.BarCode,
                    job           = \'ProductQuantity\',
                    commentaire   = JSON_OBJECT(
                        \'trigger\', \'trigger_fmsync_produits_vente_update\',
                        \'cms\', \'' . self::CMS_CODE . '\',
                        \'vente\', NEW.Vente,
                        \'id_stock\', NEW.StockID,
                        \'code_magasin\', NEW.CodeMag,
                        \'couleur\', NEW.Couleur,
                        \'taille\', NEW.Taille,
                        \'quantite\', NEW.Quantite,
                        \'motif\', NEW.Motif
                    ),
                    date_creation = NOW(),
                    date_maj      = NOW()
                ON DUPLICATE KEY UPDATE date_maj = NOW();
            END;';
    }

    /**
     * Get orders related triggers
     *
     * @return void
     */
    protected function setOrdersTriggers()
    {
        // ventes
        $this->sql['triggers']['trigger_fmsync_vente_update'] = '
            CREATE TRIGGER trigger_fmsync_vente_update
                AFTER UPDATE
                ON ventes
                FOR EACH ROW
            BEGIN
                INSERT INTO fmsync_job_queue
                SET priorite      = 20,
                    identifiant   = NEW.Vente,
                    job           = \'OrderStatus\',
                    commentaire   = JSON_OBJECT(
                        \'trigger\', \'trigger_fmsync_vente_update\',
                        \'cms\', \'' . self::CMS_CODE . '\',
                        \'vente\', NEW.Vente,
                        \'code_magasin\', NEW.CodeMag,
                        \'nature\', NEW.Nature
                    ),
                    date_creation = NOW(),
                    date_maj      = NOW()
                ON DUPLICATE KEY UPDATE date_maj = NOW();
            END;';
    }
}
