<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-07-23
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker;

use Fastmag\Sync\Exception\ProcessException;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\System\Connection\Proxy as FastmagSql;
use Fastmag\Sync\Process\Worker;
use Magento\Framework\App\ResourceConnection;

/**
 * Class Integration
 *
 * Abstract class inherited by all integration workers (to Fastmag and to Magento)
 */
abstract class Integration extends Worker
{
    /** @var Config $config */
    protected $config;

    /**
     * Customer constructor.
     *
     * @param Logger             $logger
     * @param ResourceConnection $resourceConnection
     * @param FastmagSql         $fastmagSql
     * @param Config             $config
     */
    public function __construct(
        Logger $logger,
        ResourceConnection $resourceConnection,
        FastmagSql $fastmagSql,
        Config $config
    ) {
        parent::__construct($logger, $resourceConnection, $fastmagSql);

        $this->config = $config;
    }

    /**
     * Returns the activation of the synchronization of the current entity
     *
     * @return bool
     */
    public function isEnabled()
    {
        return true;
    }

    /**
     * Check initial conditions to run the worker
     *
     * @throws ProcessException
     */
    protected function initiate()
    {
        if (!$this->isEnabled()) {
            throw new ProcessException(__('Worker "%1" was called, even though it is disabled', $this->code));
        } elseif ($this->jobs->count() <= 0) {
            throw new ProcessException(__('Worker "%1" was called, but without jobs to integrate', $this->code));
        }
    }
}
