<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-07-06
 ******************************************************************************/

namespace Fastmag\Sync\Block\Adminhtml\Preconfig;

use Fastmag\Sync\Model\System\Connection\Sql\EdiSql;
use Magento\Backend\Block\Template;
use Magento\Backend\Block\Template\Context;

/**
 * Class Form
 *
 * Block class for form element on preconfig page
 */
class Form extends Template
{
    /** @var EdiSql $ediSql */
    protected $ediSql;

    /**
     * Form constructor.
     *
     * @param Context $context
     * @param EdiSql  $ediSql
     * @param array   $data
     */
    public function __construct(Context $context, EdiSql $ediSql, array $data = [])
    {
        parent::__construct($context, $data);

        $this->ediSql = $ediSql;
    }

    /**
     * Returns data source (given by config field)
     *
     * @return string
     */
    public function getDataSource()
    {
        return $this->ediSql->getDataSource();
    }
}
