<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-08-26
 ******************************************************************************/

namespace Fastmag\Sync\Model\ResourceModel\Rule;

use Fastmag\Sync\Api\Data\Rule\StoresellerInterface as ModelInterface;
use Fastmag\Sync\Model\Rule\Storeseller as Model;
use Magento\Framework\DB\Select;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;

/**
 * Class Storeseller
 *
 * Storeseller rules model resource
 *
 * @method ModelInterface save(ModelInterface $object)
 * @method bool delete(ModelInterface $object)
 */
class Storeseller extends AbstractDb
{
    /**
     * Storeseller constructor
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init('fastmag_sync_rule_storeseller', 'rule_id');
    }

    /**
     * Load rule with Magento store ID
     *
     * @param Model $rule
     * @param int   $storeId
     *
     * @return $this
     *
     * @see AbstractDb::load
     *
     * @throws LocalizedException
     */
    public function loadByStoreId($rule, $storeId)
    {
        $connection = $this->getConnection();

        if ($connection && $storeId !== null) {
            $select = $this->_getLoadByStoreId($storeId);
            $data = $connection->fetchRow($select);

            if ($data) {
                $rule->setData($data);
            }
        }

        $this->unserializeFields($rule);
        $this->_afterLoad($rule);
        $rule->afterLoad();
        $rule->setOrigData();
        $rule->setHasDataChanges(false);

        return $this;
    }

    /**
     * Retrieve select rule for load object data by Magento store ID
     *
     * @param int $storeId
     *
     * @return Select
     *
     * @see AbstractDb::_getLoadSelect
     *
     * @throws LocalizedException
     */
    protected function _getLoadByStoreId($storeId)
    {
        $fastmagIdField = $this->getConnection()
            ->quoteIdentifier(sprintf('%s.%s', $this->getMainTable(), ModelInterface::STORE_ID));

        return $this->getConnection()->select()->from($this->getMainTable())
            ->where($fastmagIdField . ' = ?', $storeId);
    }
}
