<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-07-23
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker\RemoteSync\Sync;

use Fastmag\Sync\Api\Jobqueue\ToMagentoRepositoryInterface;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Jobqueue\ToMagentoFactory;
use Fastmag\Sync\Model\System\Connection\Proxy as FastmagSql;
use Fastmag\Sync\Process\Worker\RemoteSync\Sync;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Exception\NoSuchEntityException;

/**
 * Class Instant
 *
 * Sync worker class used for sync all jobs which can be processed immediately
 */
class Instant extends Sync
{
    /** @inheritDoc */
    protected $code = 'remotesync_sync_instant';

    /** @var ToMagentoFactory $jobFactory */
    protected $jobFactory;

    /** @var ToMagentoRepositoryInterface $jobRepository */
    protected $jobRepository;

    /**
     * Instant constructor
     *
     * @param Logger                       $logger
     * @param ResourceConnection           $resourceConnection
     * @param FastmagSql                   $fastmagSql
     * @param ToMagentoFactory             $jobFactory
     * @param ToMagentoRepositoryInterface $jobRepository
     */
    public function __construct(
        Logger $logger,
        ResourceConnection $resourceConnection,
        FastmagSql $fastmagSql,
        ToMagentoFactory $jobFactory,
        ToMagentoRepositoryInterface $jobRepository
    ) {
        parent::__construct($logger, $resourceConnection, $fastmagSql);

        $this->jobFactory = $jobFactory;
        $this->jobRepository = $jobRepository;
    }

    /**
     * @inheritDoc
     */
    protected function saveJob($event)
    {
        $createdAtDate = $this->getUtcDateTimeFromFastmag($event['date_maj']);

        try {
            $job = $this->jobRepository->getByUniqueKey(
                $event['identifiant'],
                $this->generateJobCode($event['job']),
                $event['priorite']
            );

            $job->setContent($event['commentaire'])
                ->setProcessedAt(null)
                ->setComment(null);
        } catch (NoSuchEntityException $exception) {
            $job = $this->jobFactory->create();

            $job->setContentId($event['identifiant'])
                ->setJobCode($this->generateJobCode($event['job']))
                ->setContent($event['commentaire'])
                ->setPriority($event['priorite'])
                ->setCreatedAt($createdAtDate);
        }

        $this->jobRepository->save($job);

        $newLastExecution = $createdAtDate;

        $this->logger->debug('Last Id : ' . $event['identifiant'] . ' - Last date : ' . $newLastExecution);

        return $newLastExecution;
    }

    /**
     * @inheritDoc
     */
    protected function getSqlCondition()
    {
        return '(date_a_traiter <= NOW() OR date_a_traiter IS NULL)';
    }
}
