<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-06-04
 ******************************************************************************/

namespace Fastmag\Sync\Process;

use Magento\Framework\ObjectManagerInterface;

/**
 * Class WorkerFactory
 *
 * Factory class for worker
 *
 * @see \Magento\Framework\View\Element\UiComponent\DataProvider\CollectionFactory
 */
class WorkerFactory
{
    /** @var ObjectManagerInterface $objectManager */
    protected $objectManager;

    /** @var string[] $workers */
    protected $workers;

    /**
     * WorkerFactory constructor
     *
     * @param ObjectManagerInterface $objectManagerInterface
     * @param Worker[]               $workers
     */
    public function __construct(
        ObjectManagerInterface $objectManagerInterface,
        array $workers = []
    ) {
        $this->objectManager = $objectManagerInterface;
        $this->workers = $workers;
    }

    /**
     * Create class instance with specified parameters
     *
     * @param string $jobCode
     * @param array  $data
     *
     * @return Worker
     */
    public function create($jobCode, array $data = [])
    {
        return $this->objectManager->create($this->workers[$jobCode], $data);
    }
}
