<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-08-26
 ******************************************************************************/

namespace Fastmag\Sync\Api\Rule;

use Fastmag\Sync\Api\Data\Rule\StoresellerInterface;
use Magento\Framework\Api\SearchCriteriaInterface;

/**
 * Interface StoresellerRepositoryInterface
 */
interface StoresellerRepositoryInterface
{
    /**
     * Save rule.
     *
     * @param \Fastmag\Sync\Api\Data\Rule\StoresellerInterface $rule
     *
     * @return \Fastmag\Sync\Api\Data\Rule\StoresellerInterface
     *
     * @throws \Magento\Framework\Exception\CouldNotSaveException
     */
    public function save(StoresellerInterface $rule);

    /**
     * Retrieve rule.
     *
     * @param int $ruleId
     *
     * @return \Fastmag\Sync\Api\Data\Rule\StoresellerInterface
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($ruleId);

    /**
     * Retrieve rule by Magento store ID.
     * If there's several rules applying to the store, retrieve the first one in DB.
     * See getListByStoreId to get all the rules applying
     *
     * @param int $storeId
     *
     * @return \Fastmag\Sync\Api\Data\Rule\StoresellerInterface
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getByStoreId($storeId);

    /**
     * Retrieve rules matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     *
     * @return \Fastmag\Sync\Api\Data\Rule\StoresellerSearchResultsInterface
     */
    public function getList(SearchCriteriaInterface $searchCriteria);

    /**
     * Shortcut method to get all rules applying to a specific store ID.
     *
     * @param int $storeId
     *
     * @return \Fastmag\Sync\Api\Data\Rule\StoresellerSearchResultsInterface
     */
    public function getListByStoreId($storeId);

    /**
     * Delete rule.
     *
     * @param \Fastmag\Sync\Api\Data\Rule\StoresellerInterface $rule
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function delete(StoresellerInterface $rule);

    /**
     * Delete rule by ID.
     *
     * @param int $ruleId
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function deleteById($ruleId);
}
