# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## Cheatsheet

### Changelog
    Added for new features.
    Changed for changes in existing functionality.
    Deprecated for soon-to-be removed features.
    Removed for now removed features.
    Fixed for any bug fixes.
    Security in case of vulnerabilities.

### Versionning
    MAJOR version when you make incompatible API changes,
    MINOR version when you add functionality in a backwards compatible manner, and
    PATCH version when you make backwards compatible bug fixes.

## Unreleased

## 0.19.3 - 2021-08-06
### Fixed
- Various errors on products synchronization

## 0.19.2 - 2021-08-05
### Added
- CMS data on monitoring
- Packagist / Composer instruction in README

### Removed
- Bitbucket link in CHANGELOG file
- DROP TABLE of other Fastmag Sync modules
- Unnecessary comment on MySQL host config field

### Fixed
- Deletion of badly configured fastmag_sync cron group

## 0.19.1 - 2021-08-04
### Added
- Config field managing product status
- Comment on EDI host config field

### Fixed
- Preconfig script
- Unknown variable error on product hydration worker

## 0.19.0 - 2021-07-30
### Added
- Installer to set default config for product tax class and attribute set

### Fixed
- Bug when job code given as parameters on CLI doesn't exist
- Various bug when data are empty on product sync
- Replace JSON_OBJECT by equivalent CONCAT in MySQL queries, as Fastmag and EDIquery do not support this function

## 0.18.0 - 2021-07-23
### Added
- Fastmag attributes automatic installation
- Product options integration worker
- Product integration worker
- Product entities for workers
- Subordonate workers can be placed before and after another worker
- Language field added in store/seller rules
- Default attribute set for products synced with Fastmag config field
- Indicative price hydratation

### Changed
- Product hydratation workersd now used product entites
- Creation date, textile data and description sync config field

### Fixed
- EDI connection test method
- Optimization of EDI Connection test in workers
- Unification of Fastmag products attributes names
- Exceptions implementation: jobs now throw only JobException

## 0.17.0 - 2021-07-01
### Added
- Check of existence of native triggers in Fastmag for stock calculation
- CMS code on the data set in the job by each trigger
- Prestashop and Magento 1 jobs tables deletion on trigger reinstall
- HM.IO monitoring system
- Products activation config field
- Test proxy connection button in config
- Base structure for products images sync

### Changed
- Composer name, description and dependancies for M2.4

### Removed
- Customers sync from Fastmag to Magento
- Reset prices and inventory levels buttons
- IP config field for proxy connection

### Fixed
- Exception added on EDI Query connection if EDI URL is empty
- Duplicate website ID config field
- Connection before triggers reinstall
- Wrong config test on customers sync from Magento to Fastmag
- Counterintuitive dependencies on products config fields
- Unique size config field select

## 0.16.0 - 2021-06-07
### Added
- PubParEmail field set on customer sync to Fastmag
- Log rotation cron and config field
- HM.IO website ID generation and display

### Fixed
- Update the column renderer checking the connection with Fastmag on Storeseller rules to use API
- Error check on integration and subordinate workers
- Notice on customer creation in frontend

### Changed
- Use of Fastmag API instead of EDI for customers' addresses sync to Fastmag

## 0.15.0 - 2021-06-07
### Added
- Reset prices and inventory levels buttons in admin, wth linked workers
- Fastmag utilitarians products creation
- Internal color product attribute
- Fastmag API connection

### Changed
- Use of Fastmag API instead of EDI for customers sync to Fastmag
- Fastmag payment codes now accepts alphanumeric codes (not only numeric ones)
- Fastmag product ID attribute nammed "fm_product_id"
- Specific directory for managers/workers/entities

### Removed
- Configurable per color feature
- Composer.json versionning
- Config fields set twice

### Fixed
- db_schema_whitelist added
- Config tabs sort order
- Triggers are now filtered by config on install/uninstall

## 0.14.0 - 2020-10-21
### Added
- Entity classes for workers to Fastmag

### Fixed
- Port is not a mandatory field anymore for EDI config
- Exception handling in subordinate workers
- EDI test method

## 0.13.0 - 2020-10-02
### Added
- Commands help on README file
- "fastmag_product_id" attributes on products and quote and order items
- Order hydration and integration worker to Fastmag

### Changed
- Call of the subordinate workers are now made by the manager
- DB declarative schemas

### Fixed
- Jobs retrieving on workers (Collection are not treated as array anymore)
- Exceptions are now unified on both SQL proxy classes

### Removed
- Seller alternatives functionality

## 0.12.2 - 2020-08-17
### Added
- Check of the existence of products before hydrating on worker tomagento_hydration_product_price
- "Stock only" config field on the Fastmag to M2 imports
- Customer deletion hydration and integration workers to Fastag

### Changed
- Implementation of additional attributes' config fields

### Fixed
- Data logged when there's an error on EDI connection
- Default port for EDI connecion supported
- Store/seller rules EDI test connection now support changes from 0.12.1 version
- Composer.json version

## 0.12.1 - 2020-08-17
### Added
- Customer hydration and integration workers to Fastag

### Changed
- Connection classes management

## 0.12.0 - 2020-07-21
### Changed
- Shifting of the preconfig page on an admin controller

### Fixed
- Reupdate DB module version given composer version
- Git files tree (root of the repository is now root of the module, not Magento) 

## 0.11.2 - 2020-06-26
### Added
- Inventory hydration worker
- Special price hydration worker
- Order hydration worker

### Changed
- New parameter added to the SQL escape method to force string convertion

### Fixed
- Serialized data save bug fixed
- Integration worker Quantity renammed as Inventory to respect Magento wording

## 0.11.1 - 2020-06-26
### Added
- New config handler
- Array echapment for SQL queries
- Product hydration worker

### Changed
- Column price_rate and price_list on store/seller rules are now called coefficient and rate_code respectively
- Fastmag triggers installer and uninstaller are now classes
- Error trace and message column type changed to MEDIUMBLOB

### Fixed
- String echapment for SQL queries now add automatically single quotes

## 0.11.0 - 2020-05-06
### Added
- Error message and trace on jobs queues (to Fastmag and to Magento)
- Job ID added to log on job related exceptions
- Entities IDs added to log when error occured during batch hydration
- Hydrated data column on Fastmag to Magento job queue

### Changed
- Arguments job-code and job-id on jobqueue command are now options

### Removed
- Address workers from Fastmag to Magento

### Deprecated
- Entity classes (data formating will be handle by integration workers)

### Fixed
- Correction of the URL in the account creation and newsletter subscription mail (if the SEO rewrite is enabled in front)
- Store/seller rules pages now display store (not website)

## 0.10.0 - 2020-05-06
### Added
- Copyrights

### Changed
- Processes are now launched as a Magento command, and not a PHP cron script

### Fixed
- Hotfix on clean remote sync worker

## 0.9.0 - 2020-04-29
### Added
- Interfaces and classes Entity to handle data transformation
- To Magento customer synchronization
- isEnabled method on tomagento integrations customer worker
- Attribute fastmag_alias on customers addresses
- "sync_id" column on synchronized customers table
- Previous cheatsheet

### Changed
- Entity workers renammed Integration workers
- Entity classes are not Worker classes anymore
- Orders, customers and logs listing are now ordered by ID desc

### Removed
- Parameter proxy to all workers construct (added to only the relevant ones instead)

### Fixed
- Get method behaviour of Direct SQL et EDI SQL are now unified
- Prices jobs priority (10 to 80)
- Wrong name for trigger_fmsync_produits_image_stock_insert trigger
- PSR-2 compliance
- @package annotations removed as requested by phpcs
- Exceptions handling improved
- Array escaped before proxy requests

## 0.8.1 - 2020-02-11
### Added
- Plugins on order refund and customer save
- Empty workers entity for order refund and customer save

### Changed
- On customer delete in Magento, the mapping with Fastmag is automatically deleted

## 0.8.0 - 2020-01-31
### Added
- Sync to Fastmag manager / worker structure
- Plugins on Order entity to create jobs
- Parameter "job-code" on bash cron to allow resync on specific jobs
- Hydration workers structure
- Logs grid page

### Changed
- Parameter "job-type" on bash cron renammed as "mode", "force-id" as "job-id"
- To Magento entity jobs now works with a bunch of jobs

### Removed
- Triggers on tables "negocelignes" and "negoceclients"

## 0.7.0 - 2019-12-19
### Added
- Products and inventory triggers on Fastmag
- Sync to Magento empty products and inventory entities workers

### Changed
- Column "label" for jobs tables changed for "job_code"
- Event table and triggers installed on Fastmag DB

### Fixed
- Cache tag for jobs models

## 0.6.0 - 2019-12-17
### Added
- Selector for payment methods filters
- Managers / workers architecture for jobs management
- Remote sync manager and workers
- Sync to Magento manager and workers
- Sync to Magento empty entities workers

### Changed
- Jobs codes to respect Magento standards

## 0.5.0 - 2019-11-19
### Added
- Log management and configuration
- Customers and orders synchronisation configuration
- Specific cron to run job queues
- Table storing jobs last execution

### Changed
- Rules' RepositoryInterface architecture (back to Magento standards)

## 0.4.0 - 2019-11-11
### Added
- Fastmag installers
- Proxy SQL access configuration and models

### Removed
- Direct SQL access configuration

## 0.3.2 - 2019-11-01
### Added
- Local job queue Fastmag to Magento grid page and linked actions
- Local scheduled job queue Fastmag to Magento grid page

## 0.3.1 - 2019-11-01
### Added
- Log table

## 0.3.0 - 2019-10-31
### Added
- Job queue Magento to Fastmag grid page

### Changed
- Remove uses of ObjectManager in controllers, following Magento best practices

## 0.2.0 - 2019-10-29
### Added
- Synchronized orders grid page
- Synchronized customers grid page

### Changed
- Rules' RepositoryInterface architecture

## 0.1.2 - 2019-10-26
### Added
- Order / Fastmag transaction rules configuration pages

## 0.1.1 - 2019-10-19
### Added
- Payment codes rules configuration pages

### Changed
- Module versioning (pre-1.0.0)

## 0.1.0 - 2019-09-15
### Added
- EDI configuration page
- Store / Seller / Stock rules configuration pages
- Specific logger

### Changed
- Module dependencies (cf. [Magento documentation](https://devdocs.magento.com/guides/v2.3/architecture/archi_perspectives/components/modules/mod_depend.html))
- Standardization of the fastmag_sync prefix
- Place of the Fastmag menu following Magento good practices

## 0.0.1 - 2019-08-20
### Added
- Module basic architecture
- Configuration pages (except About and EDI pages)
