<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-07-23
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\System\Config\Connection;

use Fastmag\Sync\Exception\ApiException;
use Fastmag\Sync\Model\System\Connection\Api as ApiConnector;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\Result\JsonFactory;

/**
 * Class Api
 *
 * API connection test action
 */
class Api extends Action
{
    /** @var string */
    public const ADMIN_RESOURCE = 'Fastmag_Sync::config';

    /** @var JsonFactory $resultJsonFactory */
    protected $resultJsonFactory;

    /** @var ApiConnector $apiConnector */
    protected $apiConnector;

    /**
     * Edi constructor
     *
     * @param Context      $context
     * @param JsonFactory  $resultJsonFactory
     * @param ApiConnector $apiConnector
     */
    public function __construct(
        Context $context,
        JsonFactory $resultJsonFactory,
        ApiConnector $apiConnector
    ) {
        parent::__construct($context);

        $this->resultJsonFactory = $resultJsonFactory;
        $this->apiConnector = $apiConnector;
    }

    /**
     * @inheritDoc
     */
    public function execute()
    {
        $result = ['test_connect' => 0];

        $host = $this->getRequest()->getParam('host');
        $chain = $this->getRequest()->getParam('chain');
        $shop = $this->getRequest()->getParam('shop');
        $username = $this->getRequest()->getParam('user');
        $password = $this->getRequest()->getParam('password');

        try {
            $this->apiConnector->setCredentials($host, $chain, $shop, $username, $password)->authenticate();
            $result['test_connect'] = 1;
        } catch (ApiException $exception) {
            $result['message'] = __('Code: %1 - Error: %2', $exception->getCode(), $exception->getMessage());
        }

        $resultJson = $this->resultJsonFactory->create();

        return $resultJson->setData($result);
    }
}
