<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-08-06
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\Rule\Storeseller;

use Exception;
use Fastmag\Sync\Api\Data\Rule\StoresellerInterface as Rule;
use Fastmag\Sync\Api\Rule\StoresellerRepositoryInterface as RuleRepository;
use Fastmag\Sync\Controller\Adminhtml\Rule\Storeseller as ControllerAbstract;
use Fastmag\Sync\Model\Rule\StoresellerFactory as RuleFactory;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Redirect;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\App\Request\DataPersistorInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Store\Api\StoreRepositoryInterface;

/**
 * Class Save
 *
 * Storeseller save action
 *
 * @todo change architecture to avoid code duplication
 */
class Save extends ControllerAbstract implements HttpPostActionInterface
{
    /** @var RuleFactory $ruleFactory */
    protected $ruleFactory;

    /** @var StoreRepositoryInterface $storeRepository */
    protected $storeRepository;

    /**
     * Save constructor
     *
     * @param Context                  $context
     * @param DataPersistorInterface   $dataPersistor
     * @param RuleRepository           $ruleRepository
     * @param RuleFactory              $ruleFactory
     * @param StoreRepositoryInterface $storeRepository
     */
    public function __construct(
        Context $context,
        DataPersistorInterface $dataPersistor,
        RuleRepository $ruleRepository,
        RuleFactory $ruleFactory,
        StoreRepositoryInterface $storeRepository
    ) {
        parent::__construct($context, $dataPersistor, $ruleRepository);

        $this->ruleFactory = $ruleFactory;
        $this->storeRepository = $storeRepository;
    }

    /**
     * Save action
     *
     * @return Redirect
     */
    public function execute()
    {
        /** @var Redirect $resultRedirect */
        $resultRedirect = $this->resultRedirectFactory->create();
        $data = $this->getRequest()->getPostValue();

        if ($data) {
            if (empty($data['rule_id'])) {
                $data['rule_id'] = null;
            }

            $rule = $this->ruleFactory->create();

            $ruleId = $this->getRequest()->getParam('rule_id');
            if ($ruleId) {
                try {
                    $rule = $this->ruleRepository->getById($ruleId);
                } catch (LocalizedException $exception) {
                    $this->messageManager->addErrorMessage(__('This rule no longer exists.'));
                    return $resultRedirect->setPath('*/*/');
                }
            }

            try {
                $store = $this->ruleRepository->getById($data['store_id']);
                $data['website_id'] = $store->getWebsiteId();
            } catch (LocalizedException $exception) {
                $this->messageManager->addErrorMessage($exception->getMessage());
            }

            $rule->setData($data);

            // TODO add MSI (Multi Source Inventory) management

            try {
                $this->ruleRepository->save($rule);
                $this->messageManager->addSuccessMessage(__('The rule has been saved.'));
                $this->dataPersistor->clear('storeseller_rule');

                return $this->processReturn($rule, $data, $resultRedirect);
            } catch (LocalizedException $exception) {
                $this->messageManager->addErrorMessage($exception->getMessage());
            } catch (Exception $exception) {
                $this->messageManager
                    ->addExceptionMessage($exception, __('Something went wrong while saving the rule.'));
            }

            $this->dataPersistor->set('storeseller_rule', $data);

            return $resultRedirect->setPath('*/*/edit', ['id' => $ruleId]);
        }

        return $resultRedirect->setPath('*/*/');
    }

    /**
     * Process and set the return
     *
     * @param Rule     $rule
     * @param array    $data
     * @param Redirect $resultRedirect
     *
     * @return Redirect
     *
     * @throws LocalizedException
     */
    private function processReturn($rule, $data, $resultRedirect)
    {
        $redirect = $data['back'] ?? 'close';

        if ($redirect === 'continue') {
            $resultRedirect->setPath('*/*/edit', ['id' => $rule->getId()]);
        } elseif ($redirect === 'close') {
            $resultRedirect->setPath('*/*/');
        } elseif ($redirect === 'duplicate') {
            $duplicateRule = $this->ruleFactory->create(['data' => $data]);
            $duplicateRule->setId(null)
                ->setData(Rule::CREATED_AT, null)
                ->setData(Rule::UPDATED_AT, null);
            $this->ruleRepository->save($duplicateRule);

            $ruleId = $duplicateRule->getId();

            $this->messageManager->addSuccessMessage(__('You duplicated the rule.'));
            $this->dataPersistor->set('storeseller_rule', $data);
            $resultRedirect->setPath('*/*/edit', ['id' => $ruleId]);
        }

        return $resultRedirect;
    }
}
