<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-07-23
 ******************************************************************************/

namespace Fastmag\Sync\Console;

use Exception;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Process\Manager\RemoteSync;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class RemoteSyncCommand
 *
 * Command class for remote sync process
 */
class RemoteSyncCommand extends Command
{
    /** @var Logger $logger */
    protected $logger;

    /** @var RemoteSync $remoteSync */
    protected $remoteSync;

    /**
     * RemoteSyncCommand constructor
     *
     * @param Logger     $logger
     * @param RemoteSync $remoteSync
     */
    public function __construct(Logger $logger, RemoteSync $remoteSync)
    {
        parent::__construct();

        $this->logger = $logger;
        $this->remoteSync = $remoteSync;
    }

    /**
     * @inheritDoc
     *
     * @return void
     */
    protected function configure()
    {
        $this->setName('fastmag-sync:remote');
        $this->setDescription('Sync remote Fastmag jobs queue in Magento local jobs queues');

        parent::configure();
    }

    /**
     * @inheritDoc
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->logger->debug('Beginning remote synchronization');

        // when called as a daemon, we need to set a sleeping time to avoid API calls multiplication
        sleep(30);

        try {
            $this->remoteSync->run();
        } catch (Exception $exception) {
            $output->writeln($exception->getMessage() . "\n" . $exception->getTraceAsString());
        }
    }
}
