<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-04-29
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\Rule;

use Fastmag\Sync\Api\Rule\StoresellerRepositoryInterface;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Page;
use Magento\Framework\App\Request\DataPersistorInterface;

/**
 * Class Storeseller
 */
abstract class Storeseller extends Action
{
    /** @var string */
    public const ADMIN_RESOURCE = 'Fastmag_Sync::store_seller';

    /** @var DataPersistorInterface $dataPersistor */
    protected $dataPersistor;

    /** @var StoresellerRepositoryInterface $ruleRepository */
    protected $ruleRepository;

    /**
     * Storeseller constructor
     *
     * @param Context                        $context
     * @param DataPersistorInterface         $dataPersistor
     * @param StoresellerRepositoryInterface $ruleRepository
     */
    public function __construct(
        Context $context,
        DataPersistorInterface $dataPersistor,
        StoresellerRepositoryInterface $ruleRepository
    ) {
        parent::__construct($context);

        $this->dataPersistor = $dataPersistor;
        $this->ruleRepository = $ruleRepository;
    }

    /**
     * Init page
     *
     * @param Page $resultPage
     *
     * @return Page
     */
    protected function initPage($resultPage)
    {
        $resultPage->setActiveMenu('Fastmag_Sync::fastmag_sync_rule_storeseller')
            ->addBreadcrumb(__('Rules'), __('Rules'))
            ->addBreadcrumb(__('Store/Seller/Stock'), __('Store/Seller/Stock'));

        return $resultPage;
    }
}
