<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-04-29
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\Rule\Storeseller;

use Fastmag\Sync\Api\Rule\StoresellerRepositoryInterface;
use Fastmag\Sync\Controller\Adminhtml\Rule\Storeseller as ControllerAbstract;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Page;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\Request\DataPersistorInterface;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\View\Result\PageFactory;

/**
 * Class Index
 *
 * Storeseller index action
 */
class Index extends ControllerAbstract implements HttpGetActionInterface
{
    /** @var PageFactory $resultPageFactory */
    protected $resultPageFactory;

    /**
     * Index constructor
     *
     * @param Context                        $context
     * @param DataPersistorInterface         $dataPersistor
     * @param StoresellerRepositoryInterface $ruleRepository
     * @param PageFactory                    $resultPageFactory
     */
    public function __construct(
        Context $context,
        DataPersistorInterface $dataPersistor,
        StoresellerRepositoryInterface $ruleRepository,
        PageFactory $resultPageFactory
    ) {
        parent::__construct($context, $dataPersistor, $ruleRepository);

        $this->resultPageFactory = $resultPageFactory;
    }

    /**
     * Display admin listing of the rules
     *
     * @return ResultInterface
     */
    public function execute()
    {
        /** @var Page $resultPage */
        $resultPage = $this->resultPageFactory->create();
        $this->initPage($resultPage)->getConfig()->getTitle()->prepend(__('Rules Store/Seller/Stock'));

        $this->dataPersistor->clear('storeseller_rule');

        return $resultPage;
    }
}
