<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-06-21
 ******************************************************************************/

namespace Fastmag\Sync\Observer;

use Fastmag\Sync\Exception\NoConnectionException;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\System\Connection\Proxy as FastmagSql;
use Magento\Framework\App\Config\Storage\WriterInterface;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

/**
 * Class SetHmioWebsiteId
 *
 * Set the HM.IO website ID in config field, if it wasn't already saved
 */
class SetHmioWebsiteId implements ObserverInterface
{
    /** @var Config */
    protected $config;

    /** @var WriterInterface $configWriter */
    protected $configWriter;

    /** @var FastmagSql $fastmagSql */
    protected $fastmagSql;

    /**
     * SetHmioWebsiteId constructor.
     *
     * @param Config          $config
     * @param WriterInterface $writer
     * @param FastmagSql      $fastmagSql
     */
    public function __construct(Config $config, WriterInterface $writer, FastmagSql $fastmagSql)
    {
        $this->config = $config;
        $this->configWriter = $writer;
        $this->fastmagSql = $fastmagSql;
    }

    /**
     * @inheritDoc
     */
    public function execute(Observer $observer)
    {
        $fastmagChain = $this->config->getValue(Config::XML_PATH_CONNECT_API_CHAIN);

        if ($fastmagChain !== null && $this->config->getValue(Config::XML_PATH_ABOUT_WEBSITE_ID) === null) {
            try {
                $testConnection = $this->fastmagSql->getConnection()->connect();
            } catch (NoConnectionException $exception) {
                $testConnection = false;
            }

            if ($testConnection) {
                // TODO : change webiste ID generation to avoid using SERVER_ADDR
                $websiteId = strtr($fastmagChain . '_' . $_SERVER['SERVER_ADDR'], [' ' => '', '.' => '']);

                $this->configWriter->save(Config::XML_PATH_ABOUT_WEBSITE_ID, $websiteId);
                $this->config->clean();
            }
        }
    }
}
