<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-07-23
 ******************************************************************************/

namespace Fastmag\Sync\Ui\Component\Listing\Column\Rule\Storeseller;

use Fastmag\Sync\Exception\ApiException;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\System\Connection\Api as ApiConnection;
use Magento\Framework\View\Asset\Repository;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;

/**
 * Class Api
 *
 * Column renderer for rules API status
 */
class Api extends Column
{
    /** @var Repository $assetRepo */
    protected $assetRepo;

    /** @var ApiConnection $apiConnection */
    protected $apiConnection;

    /** @var Config $config */
    protected $config;

    /**
     * Edi constructor
     *
     * @param ContextInterface   $context
     * @param UiComponentFactory $uiComponentFactory
     * @param Repository         $assetRepo
     * @param ApiConnection      $apiConnection
     * @param Config             $config
     * @param array              $components
     * @param array              $data
     */
    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        Repository $assetRepo,
        ApiConnection $apiConnection,
        Config $config,
        array $components = [],
        array $data = []
    ) {
        parent::__construct($context, $uiComponentFactory, $components, $data);

        $this->assetRepo = $assetRepo;
        $this->apiConnection = $apiConnection;
        $this->config = $config;
    }

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     *
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                $item[$this->getData('name')] = $this->prepareItem($item);
            }
        }

        return $dataSource;
    }

    /**
     * Get data
     *
     * @param array $item
     *
     * @return string
     */
    protected function prepareItem(array $item)
    {
        $response = false;
        $errorMessage = '';

        $this->apiConnection->setCredentials(
            $this->config->getValue(Config::XML_PATH_CONNECT_API_HOST),
            $item['chain'],
            $item['fastmag_shop'],
            $this->config->getValue(Config::XML_PATH_CONNECT_API_USER),
            $this->config->getValue(Config::XML_PATH_CONNECT_API_PASSWORD)
        );

        try {
            $response = $this->apiConnection->authenticate();
        } catch (ApiException $exception) {
            $errorMessage = $exception->getMessage();
        }

        if ($response !== true) {
            $content = '<img src="' . $this->assetRepo->getUrl('Fastmag_Sync::images/nok.gif') . '"
                alt="' . __('API connection - Error') . '"
                title="' . __('API connection - Error: %1', strip_tags($errorMessage)) . '" />';
        } else {
            $content = '<img src="' . $this->assetRepo->getUrl('Fastmag_Sync::images/ok.gif') . '"
                alt="' . __('API connection - OK') . '"
                title="' . __('API connection - OK') . '" />';
        }

        return $content;
    }
}
