<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-07-30
 ******************************************************************************/

namespace Fastmag\Sync\Api\Data\Jobqueue;

/**
 * Interface ToMagentoInterface
 */
interface ToMagentoInterface
{
    /** @var string */
    public const JOB_ID = 'job_id';

    /** @var string */
    public const CONTENT_ID = 'content_id';

    /** @var string */
    public const JOB_CODE = 'job_code';

    /** @var string */
    public const CONTENT = 'content';

    /** @var string */
    public const STATUS = 'status';

    /** @var string */
    public const CREATED_AT = 'created_at';

    /** @var string */
    public const SCHEDULED_AT = 'scheduled_at';

    /** @var string */
    public const PROCESSED_AT = 'processed_at';

    /** @var string */
    public const COMMENT = 'comment';

    /** @var string */
    public const PRIORITY = 'priority';

    /** @var string */
    public const HYDRATED_DATA = 'hydrated_data';

    /** @var string */
    public const MESSAGE = 'message';

    /** @var string */
    public const TRACE = 'trace';

    /** @var string */
    public const ENTITY = 'entity';

    /** @var string */
    public const STATUS_ERROR = 0;

    /** @var string */
    public const STATUS_OK = 1;

    /**
     * Get ID
     *
     * @return int|null
     */
    public function getId();

    /**
     * Get content ID
     *
     * @return string|null
     */
    public function getContentId();

    /**
     * Get job code
     *
     * @return string|null
     */
    public function getJobCode();

    /**
     * Get content
     *
     * @return string|null
     */
    public function getContent();

    /**
     * Get status
     *
     * @return bool|null
     */
    public function getStatus();

    /**
     * Get created at
     *
     * @return string|null
     */
    public function getCreatedAt();

    /**
     * Get scheduled at
     *
     * @return string|null
     */
    public function getScheduledAt();

    /**
     * Get processed at
     *
     * @return string|null
     */
    public function getProcessedAt();

    /**
     * Get comment
     *
     * @return string|null
     */
    public function getComment();

    /**
     * Get priority
     *
     * @return int|null
     */
    public function getPriority();

    /**
     * Get hydrated data
     *
     * @return array|null
     */
    public function getHydratedData();

    /**
     * Get error message
     *
     * @return string|null
     */
    public function getMessage();

    /**
     * Get error trace
     *
     * @return string|null
     */
    public function getTrace();

    /**
     * Get entity
     *
     * @return \Fastmag\Sync\Process\EntityInterface
     */
    public function getEntity();

    /**
     * Set ID
     *
     * @param int $jobId
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface
     */
    public function setId($jobId);

    /**
     * Set content ID
     *
     * @param int $contentId
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface
     */
    public function setContentId($contentId);

    /**
     * Set job code
     *
     * @param string $jobCode
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface
     */
    public function setJobCode($jobCode);

    /**
     * Set content
     *
     * @param string $content
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface
     */
    public function setContent($content);

    /**
     * Set status
     *
     * @param bool $status
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface
     */
    public function setStatus($status);

    /**
     * Set created at
     *
     * @param string $createdAt
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface
     */
    public function setCreatedAt($createdAt);

    /**
     * Set scheduled at
     *
     * @param string $scheduledAt
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface
     */
    public function setScheduledAt($scheduledAt);

    /**
     * Set processed at
     *
     * @param string $processedAt
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface
     */
    public function setProcessedAt($processedAt);

    /**
     * Set comment
     *
     * @param string $comment
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface
     */
    public function setComment($comment);

    /**
     * Set priority
     *
     * @param int $priority
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface
     */
    public function setPriority($priority);

    /**
     * Set hydrated data
     *
     * @param array $data
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface
     */
    public function setHydratedData($data);

    /**
     * Set error message
     *
     * @param string $message
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface
     */
    public function setMessage($message);

    /**
     * Set error trace
     *
     * @param string $trace
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface
     */
    public function setTrace($trace);

    /**
     * Set entity
     *
     * @param \Fastmag\Sync\Process\EntityInterface $entity
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface
     */
    public function setEntity($entity);

    /**
     * Add exception trace
     *
     * @param \Exception $exception
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface
     */
    public function traceException($exception);

    /**
     * Check if the job did get a previous error during the process
     *
     * @return bool
     */
    public function isInError();
}
