<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-08-09
 ******************************************************************************/

namespace Fastmag\Sync\Block\Adminhtml\Rule\Taxclassfamily\Edit\Button;

use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

/**
 * Class DeleteButton
 *
 * @todo change architecture to avoid code duplication
 */
class Delete extends Generic implements ButtonProviderInterface
{
    /**
     * @inheritDoc
     *
     * @throws LocalizedException
     */
    public function getButtonData()
    {
        $data = [];
        if ($this->getRuleId()) {
            $data = [
                'label' => __('Delete rule'),
                'class' => 'delete',
                'on_click' => 'deleteConfirm(\'' . __('Are you sure you want to do this?')
                    . '\', \'' . $this->getDeleteUrl() . '\', {"data": {}})',
                'sort_order' => 20,
            ];
        }
        return $data;
    }

    /**
     * URL to send delete requests to.
     *
     * @return string
     *
     * @throws LocalizedException
     */
    public function getDeleteUrl()
    {
        return $this->getUrl('*/*/delete', ['id' => $this->getRuleId()]);
    }
}
