<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-08-11
 ******************************************************************************/

namespace Fastmag\Sync\Model\Api;

use Fastmag\Sync\Api\ConnectionRepositoryInterface;
use \Fastmag\Sync\Api\Data\Connection\StatusInterfaceFactory as StatusFactory;
use \Fastmag\Sync\Api\Data\Connection\StatusResponseInterfaceFactory as StatusResponseFactory;
use Fastmag\Sync\Exception\ApiException;
use Fastmag\Sync\Exception\NoConnectionException;
use Fastmag\Sync\Model\System\Connection\Api as ApiConnecteor;
use Fastmag\Sync\Model\System\Connection\Sql\DirectSql as MysqlConnector;
use Fastmag\Sync\Model\System\Connection\Sql\EdiSql as EdiQueryConnector;

/**
 * Class ConnectionRepository
 *
 * Implements actual code of Fastmag connection status check REST API
 */
class ConnectionRepository implements ConnectionRepositoryInterface
{
    /** @var ApiConnecteor $apiConnector */
    protected $apiConnector;

    /** @var EdiQueryConnector $ediQueryConnector */
    protected $ediQueryConnector;

    /** @var MysqlConnector $mysqlConnector */
    protected $mysqlConnector;

    /** @var StatusResponseFactory $statusResponseFactory */
    protected $statusResponseFactory;

    /** @var StatusFactory $statusFactory */
    protected $statusFactory;

    /**
     * ConnectionRepository constructor
     *
     * @param ApiConnecteor         $apiConnector
     * @param EdiQueryConnector     $ediQueryConnector
     * @param MysqlConnector        $mysqlConnector
     * @param StatusResponseFactory $statusResponseFactory
     * @param StatusFactory         $statusFactory
     */
    public function __construct(
        ApiConnecteor $apiConnector,
        EdiQueryConnector $ediQueryConnector,
        MysqlConnector $mysqlConnector,
        StatusResponseFactory $statusResponseFactory,
        StatusFactory $statusFactory
    ) {
        $this->apiConnector = $apiConnector;
        $this->ediQueryConnector = $ediQueryConnector;
        $this->mysqlConnector = $mysqlConnector;
        $this->statusResponseFactory = $statusResponseFactory;
        $this->statusFactory = $statusFactory;
    }

    /**
     * @inheritDoc
     */
    public function checkStatus()
    {
        $response = $this->statusResponseFactory->create();

        $apiResult = $this->statusFactory->create();
        try {
            $this->apiConnector->authenticate();
            $apiResult->setStatus(true);
        } catch (ApiException $exception) {
            $apiResult->setStatus(false)
                ->setMessage(__(
                    'API connection error: Code: %1 - Error: %2',
                    $exception->getCode(),
                    $exception->getMessage()
                ));
        }
        $response->setApi($apiResult);

        $ediResult = $this->statusFactory->create();
        try {
            $this->ediQueryConnector->connect();
            $ediResult->setStatus(true);
        } catch (NoConnectionException $exception) {
            $ediResult->setStatus(false)
                ->setMessage(__('EDI connection error: %1', $exception->getMessage()));
        }
        $response->setEdi($ediResult);

        $mysqlResult = $this->statusFactory->create();
        try {
            $this->mysqlConnector->connect();
            $mysqlResult->setStatus(true);
        } catch (NoConnectionException $exception) {
            $mysqlResult->setStatus(false)
                ->setMessage(__('Proxy connection error: %1', $exception->getMessage()));
        }
        $response->setMysql($mysqlResult);

        return $response;
    }
}
