<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-04-29
 ******************************************************************************/

namespace Fastmag\Sync\Model\Jobqueue;

use Fastmag\Sync\Api\Data\Jobqueue\ToMagentoScheduledInterface;
use Fastmag\Sync\Model\Jobqueue;
use Fastmag\Sync\Model\ResourceModel\Jobqueue\ToMagentoScheduled as ResourceModel;

/**
 * Class ToMagentoScheduled
 *
 * Model class for scheduled Fastmag to Magento synchronization jobs
 */
class ToMagentoScheduled extends Jobqueue implements ToMagentoScheduledInterface
{
    /** @var string */
    public const CACHE_TAG = 'fastmag_sync_jobqueue_tomagento_scheduled';

    /** @var string $_cacheTag */
    protected $_cacheTag = self::CACHE_TAG;

    /**
     * ToMagentoScheduled constructor
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init(ResourceModel::class);
    }

    /**
     * @inheritDoc
     */
    public function getId()
    {
        return $this->getData(self::JOB_ID);
    }

    /**
     * @inheritDoc
     */
    public function getContentId()
    {
        return $this->getData(self::CONTENT_ID);
    }

    /**
     * @inheritDoc
     */
    public function getJobCode()
    {
        return $this->getData(self::JOB_CODE);
    }

    /**
     * @inheritDoc
     */
    public function getFastmagShop()
    {
        return $this->getData(self::FASTMAG_SHOP);
    }

    /**
     * @inheritDoc
     */
    public function getContent()
    {
        return $this->getData(self::CONTENT);
    }

    /**
     * @inheritDoc
     */
    public function getCreatedAt()
    {
        return $this->getData(self::CREATED_AT);
    }

    /**
     * @inheritDoc
     */
    public function getScheduledAt()
    {
        return $this->getData(self::SCHEDULED_AT);
    }

    /**
     * @inheritDoc
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId()];
    }

    /**
     * @inheritDoc
     */
    public function setId($jobId)
    {
        return $this->setData(self::JOB_ID, $jobId);
    }

    /**
     * @inheritDoc
     */
    public function setContentId($contentId)
    {
        return $this->setData(self::CONTENT_ID, $contentId);
    }

    /**
     * @inheritDoc
     */
    public function setJobCode($jobCode)
    {
        return $this->setData(self::JOB_CODE, $jobCode);
    }

    /**
     * @inheritDoc
     */
    public function setFastmagShop($fastmagShop)
    {
        return $this->setData(self::FASTMAG_SHOP, $fastmagShop);
    }

    /**
     * @inheritDoc
     */
    public function setContent($content)
    {
        return $this->setData(self::CONTENT, $content);
    }

    /**
     * @inheritDoc
     */
    public function setCreatedAt($createdAt)
    {
        return $this->setData(self::CREATED_AT, $createdAt);
    }

    /**
     * @inheritDoc
     */
    public function setScheduledAt($scheduledAt)
    {
        return $this->setData(self::SCHEDULED_AT, $scheduledAt);
    }
}
