<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-09-25
 ******************************************************************************/

namespace Fastmag\Sync\Api\Data\Rule;

/**
 * Interface OrdertransactionInterface
 */
interface OrdertransactionInterface
{
    /** @var string */
    public const RULE_ID = 'rule_id';

    /** @var string */
    public const CREATED_AT = 'created_at';

    /** @var string */
    public const UPDATED_AT = 'updated_at';

    /** @var string */
    public const PAYMENT_METHOD = 'payment_method';

    /** @var string */
    public const ORDER_STATUS = 'order_status';

    /** @var string */
    public const TRANSACTION_TYPE = 'transaction_type';

    /** @var string */
    public const FASTMAG_TRANSACTION_TYPE_NONE = 'AUCUNE';

    /** @var string */
    public const FASTMAG_TRANSACTION_TYPE_SALE = 'VENTE';

    /** @var string */
    public const FASTMAG_TRANSACTION_TYPE_ORDER = 'COMMANDE';

    /** @var string */
    public const FASTMAG_TRANSACTION_TYPE_RESERVATION = 'RESA';

    /** @var string */
    public const FASTMAG_TRANSACTION_TYPE_RESERVATIONTOSALE = 'RESA2VENTE';

    /** @var string */
    public const FASTMAG_TRANSACTION_TYPE_CANCELLATION = 'ANNULATION';

    /** @var string */
    public const FASTMAG_TRANSACTION_TYPE_RMA = 'RETOUR';

    /** @var string */
    public const FASTMAG_TRANSACTION_TYPE_TRANSFER = 'TRANS';

    /**
     * Get ID
     *
     * @return int|null
     */
    public function getId();

    /**
     * Get created at
     *
     * @return string|null
     */
    public function getCreatedAt();

    /**
     * Get updated at
     *
     * @return string|null
     */
    public function getUpdatedAt();

    /**
     * Get payment method
     *
     * @return string|null
     */
    public function getPaymentMethod();

    /**
     * Get order status
     *
     * @return string|null
     */
    public function getOrderStatus();

    /**
     * Get transaction type
     *
     * @return string|null
     */
    public function getTransactionType();

    /**
     * Set ID
     *
     * @param int $ruleId
     *
     * @return \Fastmag\Sync\Api\Data\Rule\OrdertransactionInterface
     */
    public function setId($ruleId);

    /**
     * Set payment method
     *
     * @param string $paymentMethod
     *
     * @return \Fastmag\Sync\Api\Data\Rule\OrdertransactionInterface
     */
    public function setPaymentMethod($paymentMethod);

    /**
     * Set order status
     *
     * @param string $orderStatus
     *
     * @return \Fastmag\Sync\Api\Data\Rule\OrdertransactionInterface
     */
    public function setOrderStatus($orderStatus);

    /**
     * Set transaction type
     *
     * @param string $transactionType
     *
     * @return \Fastmag\Sync\Api\Data\Rule\OrdertransactionInterface
     */
    public function setTransactionType($transactionType);
}
