<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-08-06
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\Rule\Taxclassfamily;

use Fastmag\Sync\Api\Rule\TaxclassfamilyRepositoryInterface;
use Fastmag\Sync\Controller\Adminhtml\Rule\Taxclassfamily as ControllerAbstract;
use Fastmag\Sync\Model\Rule\TaxclassfamilyFactory;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Page;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\Request\DataPersistorInterface;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\View\Result\PageFactory;

/**
 * Class Edit
 *
 * Ordertransaction edit action
 *
 * @todo change architecture to avoid code duplication
 */
class Edit extends ControllerAbstract implements HttpGetActionInterface
{
    /** @var PageFactory $resultPageFactory */
    protected $resultPageFactory;

    /** @var TaxclassfamilyFactory $ruleFactory */
    protected $ruleFactory;

    /**
     * Edit constructor
     *
     * @param Context                           $context
     * @param DataPersistorInterface            $dataPersistor
     * @param TaxclassfamilyRepositoryInterface $ruleRepository
     * @param PageFactory                       $resultPageFactory
     * @param TaxclassfamilyFactory             $ruleFactory
     */
    public function __construct(
        Context $context,
        DataPersistorInterface $dataPersistor,
        TaxclassfamilyRepositoryInterface $ruleRepository,
        PageFactory $resultPageFactory,
        TaxclassfamilyFactory $ruleFactory
    ) {
        parent::__construct($context, $dataPersistor, $ruleRepository);

        $this->resultPageFactory = $resultPageFactory;
        $this->ruleFactory = $ruleFactory;
    }

    /**
     * Edit existing rule
     *
     * @return ResultInterface
     *
     * @throws LocalizedException
     * @throws NoSuchEntityException
     */
    public function execute()
    {
        $ruleId = $this->getRequest()->getParam('id');

        if ($ruleId) {
            $rule = $this->ruleRepository->getById($ruleId);
            
            if (!$rule->getId()) {
                $this->messageManager->addErrorMessage(__('This rule no longer exists.'));
                $resultRedirect = $this->resultRedirectFactory->create();

                return $resultRedirect->setPath('*/*/');
            }
        } else {
            $rule = $this->ruleFactory->create();
        }

        $this->dataPersistor->set('taxclassfamily_rule', $rule->getData());

        /** @var Page $resultPage */
        $resultPage = $this->resultPageFactory->create();
        $this->initPage($resultPage)->addBreadcrumb(
            $ruleId ? __('Edit Rule') : __('New Rule'),
            $ruleId ? __('Edit Rule') : __('New Rule')
        );
        $resultPage->getConfig()->getTitle()->prepend(__('Fastmag Sync'));
        $resultPage->getConfig()->getTitle()->prepend(__('Tax Class/Family'));
        $resultPage->getConfig()->getTitle()->prepend($rule->getId() ? __('Edit Rule') : __('New Rule'));

        return $resultPage;
    }
}
