<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-04-29
 ******************************************************************************/

namespace Fastmag\Sync\Model\Config\Source\Jobqueue;

use Magento\Framework\Data\OptionSourceInterface;

/**
 * Class Reactivity
 *
 * Source for job reactivity config field
 */
class Reactivity implements OptionSourceInterface
{
    /**
     * @inheritDoc
     */
    public function toOptionArray()
    {
        return [
            ['value' => '1', 'label' => __('Instant (1 sec)')],
            ['value' => '5', 'label' => __('Quick (5 sec)')],
            ['value' => '15', 'label' => __('Normal (15 sec)')],
            ['value' => '30', 'label' => __('Slow (30 sec)')],
            ['value' => '60', 'label' => __('Slower (60 sec)')],
        ];
    }

    /**
     * Returns values as associative array
     *
     * @return array
     */
    public function toArray()
    {
        return [
            '1' => __('Instant (1 sec)'),
            '5' => __('Quick (5 sec)'),
            '15' => __('Normal (15 sec)'),
            '30' => __('Slow (30 sec)'),
            '60' => __('Slower (60 sec)'),
        ];
    }
}