<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-08-23
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker\ToFastmag;

use Fastmag\Sync\Api\Jobqueue\ToFastmagRepositoryInterface as JobRepository;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\ResourceModel\Jobqueue\ToFastmag\Collection;
use Fastmag\Sync\Model\System\Connection\Api;
use Fastmag\Sync\Process\Worker;
use Fastmag\Sync\Process\Worker\FastmagApi as FastmagApiTrait;
use Fastmag\Sync\Process\Worker\Integration as IntegrationTrait;

/**
 * Class Integration
 *
 * Abstract class inherited by all ToFastmag integration workers
 *
 * @method Collection getJobs()
 */
abstract class Integration extends Worker
{
    use IntegrationTrait;
    use FastmagApiTrait;

    public const DEFAULT_REFERER = 'Magento';

    /**
     * Integration constructor.
     *
     * @param Logger             $logger
     * @param JobRepository      $jobRepository
     * @param Api                $api
     */
    public function __construct(
        Logger $logger,
        JobRepository $jobRepository,
        Api $api
    ) {
        parent::__construct($logger);

        $this->jobRepository = $jobRepository;
        $this->api = $api;
    }
}
