<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-08-23
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker\ToMagento;

use Fastmag\Sync\Api\Jobqueue\ToMagentoRepositoryInterface as JobRepository;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\ResourceModel\Jobqueue\ToMagento\Collection;
use Fastmag\Sync\Process\Worker;
use Fastmag\Sync\Process\Worker\Integration as IntegrationTrait;

/**
 * Class Integration
 *
 * Abstract class inherited by all integration workers
 *
 * @method Collection getJobs()
 */
abstract class Integration extends Worker
{
    use IntegrationTrait;

    /** @var Config $config */
    protected $config;

    /**
     * Integration constructor.
     *
     * @param Logger        $logger
     * @param JobRepository $jobRepository
     * @param Config        $config
     */
    public function __construct(
        Logger $logger,
        JobRepository $jobRepository,
        Config $config
    ) {
        parent::__construct($logger);

        $this->jobRepository = $jobRepository;
        $this->config = $config;
    }
}
