<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-04-29
 ******************************************************************************/

namespace Fastmag\Sync\Api;

use Fastmag\Sync\Api\Data\CustomerInterface;
use Magento\Framework\Api\SearchCriteriaInterface;

/**
 * Interface CustomerRepositoryInterface
 */
interface CustomerRepositoryInterface
{
    /**
     * Save customer.
     *
     * @param \Fastmag\Sync\Api\Data\CustomerInterface $customer
     *
     * @return \Fastmag\Sync\Api\Data\CustomerInterface
     *
     * @throws \Magento\Framework\Exception\CouldNotSaveException
     */
    public function save(CustomerInterface $customer);

    /**
     * Retrieve customer.
     *
     * @param int $entityId
     *
     * @return \Fastmag\Sync\Api\Data\CustomerInterface
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getById($entityId);

    /**
     * Retrieve customer by Magento ID.
     *
     * @param int $magentoId
     *
     * @return \Fastmag\Sync\Api\Data\CustomerInterface
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getByMagentoId($magentoId);

    /**
     * Retrieve customer by Fastmag ID.
     *
     * @param int $fastmagId
     *
     * @return \Fastmag\Sync\Api\Data\CustomerInterface
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getByFastmagId($fastmagId);

    /**
     * Retrieve customers matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     *
     * @return \Fastmag\Sync\Api\Data\CustomerSearchResultsInterface
     */
    public function getList(SearchCriteriaInterface $searchCriteria);

    /**
     * Delete customer.
     *
     * @param \Fastmag\Sync\Api\Data\CustomerInterface $customer
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function delete(CustomerInterface $customer);

    /**
     * Delete customer by ID.
     *
     * @param int $entityId
     *
     * @return bool true on success
     *
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\CouldNotDeleteException
     */
    public function deleteById($entityId);
}
