<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-04-29
 ******************************************************************************/

namespace Fastmag\Sync\Controller\Adminhtml\Rule\Paymentcode;

use Fastmag\Sync\Api\Rule\PaymentcodeRepositoryInterface;
use Fastmag\Sync\Controller\Adminhtml\Rule\Paymentcode as ControllerAbstract;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Page;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\Request\DataPersistorInterface;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\View\Result\PageFactory;

/**
 * Class Index
 *
 * Paymentcode index action
 */
class Index extends ControllerAbstract implements HttpGetActionInterface
{
    /** @var PageFactory $resultPageFactory */
    protected $resultPageFactory;

    /**
     * Index constructor
     *
     * @param Context                        $context
     * @param DataPersistorInterface         $dataPersistor
     * @param PaymentcodeRepositoryInterface $ruleRepository
     * @param PageFactory                    $resultPageFactory
     */
    public function __construct(
        Context $context,
        DataPersistorInterface $dataPersistor,
        PaymentcodeRepositoryInterface $ruleRepository,
        PageFactory $resultPageFactory
    ) {
        parent::__construct($context, $dataPersistor, $ruleRepository);

        $this->resultPageFactory = $resultPageFactory;
    }

    /**
     * Display admin listing of the rules
     *
     * @return ResultInterface
     */
    public function execute()
    {
        /** @var Page $resultPage */
        $resultPage = $this->resultPageFactory->create();
        $this->initPage($resultPage)->getConfig()->getTitle()->prepend(__('Rules Payment/Code'));

        $this->dataPersistor->clear('paymentcode_rule');

        return $resultPage;
    }
}
