<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-08-24
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker;

use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\Jobqueue;
use Fastmag\Sync\Process\EntityInterface;
use Magento\Framework\Serialize\Serializer\Json;

/**
 * Trait Hydration
 *
 * Trait for all hydration workers (to Fastmag and to Magento)
 */
trait Hydration
{
    use Standard;

    /** @var Config $config */
    protected $config;

    /** @var Json $jsonSerializer */
    protected $jsonSerializer;

    /**
     * Get config limit for hydration
     *
     * @return string
     */
    protected function getLimit()
    {
        return $this->config->getValue(Config::XML_PATH_JOBQUEUE_ADVANCED_HYDRATION_SIZE);
    }

    /**
     * Hydrate job with entity
     *
     * @param Jobqueue        $job
     * @param EntityInterface $entity
     *
     * @return Standard
     */
    public function hydrateJob($job, $entity)
    {
        $this->jobRepository->hydrate($job, $entity);

        $this->log($job, 'Data hydrated: ' . $this->jsonSerializer->serialize($entity->export()));

        return $this;
    }
}
