<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-08-23
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker\ToFastmag;

use Fastmag\Sync\Api\Jobqueue\ToFastmagRepositoryInterface as JobRepository;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Config;
use Fastmag\Sync\Model\ResourceModel\Jobqueue\ToFastmag\Collection;
use Fastmag\Sync\Process\EntityInterface;
use Fastmag\Sync\Process\Worker;
use Fastmag\Sync\Process\Worker\Hydration as HydrationTrait;
use Magento\Framework\Serialize\Serializer\Json;

/**
 * Class Hydration
 *
 * Abstract class inherited by all ToFastmag hydration workers
 *
 * @method Collection getJobs()
 */
abstract class Hydration extends Worker
{
    use HydrationTrait;

    /**
     * Hydration constructor.
     *
     * @param Logger        $logger
     * @param JobRepository $jobRepository
     * @param Config        $config
     * @param Json          $jsonSerializer
     */
    public function __construct(
        Logger $logger,
        JobRepository $jobRepository,
        Config $config,
        Json $jsonSerializer
    ) {
        parent::__construct($logger);

        $this->jobRepository = $jobRepository;
        $this->config = $config;
        $this->jsonSerializer = $jsonSerializer;
    }

    /**
     * Run the queries to Magento returns the data as an array
     *
     * @return EntityInterface|EntityInterface[]
     */
    abstract protected function getDataFromMagento();
}
