<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2020 HOMEMADE.IO SAS
 * @date      2020-06-10
 ******************************************************************************/

namespace Fastmag\Sync\Api\Data\Jobqueue;

/**
 * Interface ToMagentoScheduledInterface
 */
interface ToMagentoScheduledInterface
{
    /** @var string */
    public const JOB_ID = 'job_id';

    /** @var string */
    public const CONTENT_ID = 'content_id';

    /** @var string */
    public const JOB_CODE = 'job_code';

    /** @var string */
    public const FASTMAG_SHOP = 'fastmag_shop';

    /** @var string */
    public const CONTENT = 'content';

    /** @var string */
    public const CREATED_AT = 'created_at';

    /** @var string */
    public const SCHEDULED_AT = 'scheduled_at';

    /**
     * Get ID
     *
     * @return int|null
     */
    public function getId();

    /**
     * Get content ID
     *
     * @return int|null
     */
    public function getContentId();

    /**
     * Get job code
     *
     * @return string|null
     */
    public function getJobCode();

    /**
     * Get fastmag shop
     *
     * @return bool|null
     */
    public function getFastmagShop();

    /**
     * Get content
     *
     * @return string|null
     */
    public function getContent();

    /**
     * Get created at
     *
     * @return string|null
     */
    public function getCreatedAt();

    /**
     * Get scheduled at
     *
     * @return string|null
     */
    public function getScheduledAt();

    /**
     * Set ID
     *
     * @param int $jobId
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoScheduledInterface
     */
    public function setId($jobId);

    /**
     * Set content ID
     *
     * @param int $contentId
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoScheduledInterface
     */
    public function setContentId($contentId);

    /**
     * Set job code
     *
     * @param string $jobCode
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoScheduledInterface
     */
    public function setJobCode($jobCode);

    /**
     * Set Fastmag shop
     *
     * @param string $fastmagShop
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoScheduledInterface
     */
    public function setFastmagShop($fastmagShop);

    /**
     * Set content
     *
     * @param string $content
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoScheduledInterface
     */
    public function setContent($content);

    /**
     * Set created at
     *
     * @param string $createdAt
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoScheduledInterface
     */
    public function setCreatedAt($createdAt);

    /**
     * Set scheduled at
     *
     * @param string $scheduledAt
     *
     * @return \Fastmag\Sync\Api\Data\Jobqueue\ToMagentoScheduledInterface
     */
    public function setScheduledAt($scheduledAt);
}
