<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-08-23
 ******************************************************************************/

namespace Fastmag\Sync\Model\Jobqueue;

use Exception;
use Fastmag\Sync\Model\Jobqueue;
use Fastmag\Sync\Process\EntityInterface;

/**
 * Class StandardRepository
 *
 * Standard job repository class
 *
 * @method Jobqueue save($job)
 */
abstract class StandardRepository
{
    /**
     * Hydrate job with entity
     *
     * @param Jobqueue        $job
     * @param EntityInterface $entity
     *
     * @return Jobqueue
     */
    public function hydrate($job, $entity)
    {
        $job->setHydratedData($entity->export())
            ->setEntity($entity);

        return $job;
    }

    /**
     * Validate job
     *
     * @param Jobqueue $job
     *
     * @return Jobqueue
     */
    public function validate($job)
    {
        $job->setStatus(Jobqueue::STATUS_OK)
            ->setProcessedAt(date('Y-m-d H:i:s'));

        return $job;
    }

    /**
     * Invalidate job
     *
     * @param Jobqueue  $job
     * @param Exception $exception
     *
     * @return Jobqueue
     */
    public function invalidate($job, $exception)
    {
        $oldMessages = $job->getMessage();
        $oldTrace = $job->getTrace();

        $job->setMessage(trim($oldMessages . "\n" . $exception->getMessage()))
            ->setTrace(trim($oldTrace . "\n" . $exception->getTraceAsString()))
            ->setStatus(Jobqueue::STATUS_ERROR);

        return $job;
    }
}
