<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-06
 ******************************************************************************/

namespace Fastmag\Sync\Model\Config\Source\Product;

use Magento\Catalog\Model\Product;
use Magento\Eav\Api\AttributeRepositoryInterface;
use Magento\Eav\Model\Entity\Attribute\Source\AbstractSource;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\Api\SortOrder;
use Magento\Framework\Api\SortOrderBuilder;

/**
 * Product attributes source model.
 *
 * Source for products attribute
 *
 * @see \Magento\Tax\Model\TaxClass\Source\Product
 */
class Attribute extends AbstractSource
{
    /** @var AttributeRepositoryInterface $attributesRepository */
    protected $attributesRepository;

    /** @var SearchCriteriaBuilder $searchCriteriaBuilder */
    protected $searchCriteriaBuilder;

    /** @var SortOrderBuilder $sortOrderBuilder */
    protected $sortOrderBuilder;

    /**
     * Attribute constructor
     *
     * @param AttributeRepositoryInterface $attributeRepositiry
     * @param SearchCriteriaBuilder        $searchCriteriaBuilder
     * @param SortOrderBuilder             $sortOrderBuilder
     */
    public function __construct(
        AttributeRepositoryInterface $attributeRepositiry,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        SortOrderBuilder $sortOrderBuilder
    ) {
        $this->attributesRepository = $attributeRepositiry;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->sortOrderBuilder = $sortOrderBuilder;
    }

    /**
     * Retrieve all product attributes.
     *
     * @param bool $withEmpty
     *
     * @return array
     */
    public function getAllOptions($withEmpty = true)
    {
        if (!$this->_options) {
            $sortOrder = $this->sortOrderBuilder->setField('attribute_code')
                ->setAscendingDirection()
                ->create();
            $searchCriteria = $this->searchCriteriaBuilder->addSortOrder($sortOrder)->create();
            $searchResults = $this->attributesRepository->getList(
                Product::ENTITY,
                $searchCriteria
            );

            foreach ($searchResults->getItems() as $attribute) {
                $this->_options[] = [
                    'value' => $attribute->getAttributeId(),
                    'label' => $attribute->getAttributeCode(),
                ];
            }
        }

        if ($withEmpty) {
            if (!$this->_options) {
                return [['value' => '0', 'label' => __('None')]];
            }

            return array_merge([['value' => '0', 'label' => __('None')]], $this->_options);
        }

        return $this->_options;
    }

    /**
     * Get a text for option value
     *
     * @param string|integer $value
     *
     * @return string
     */
    public function getOptionText($value)
    {
        $options = $this->getAllOptions();

        foreach ($options as $item) {
            if ($item['value'] == $value) {
                return $item['label'];
            }
        }

        return false;
    }
}
