<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-02-15
 ******************************************************************************/

namespace Fastmag\Sync\Model\ResourceModel\Rule;

use Fastmag\Sync\Api\Data\Rule\PaymentcodeInterface as ModelInterface;
use Fastmag\Sync\Model\Rule\Paymentcode as Model;
use Magento\Framework\Model\AbstractModel;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;
use Magento\Framework\Model\ResourceModel\Db\Context;
use Magento\Framework\Serialize\Serializer\Json;

/**
 * Class Paymentcode
 *
 * Paymentcode rules model resource
 *
 * @method bool delete(ModelInterface $object)
 */
class Paymentcode extends AbstractDb
{
    /** @var Json $jsonSerializer */
    protected $jsonSerializer;

    /**
     * ToMagento constructor.
     *
     * @param Context     $context
     * @param Json        $jsonSerializer
     * @param string|null $connectionName
     */
    public function __construct(Context $context, Json $jsonSerializer, $connectionName = null)
    {
        parent::__construct($context, $connectionName);

        $this->jsonSerializer = $jsonSerializer;
    }

    /**
     * Paymentcode constructor
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_init('fastmag_sync_rule_paymentcode', 'rule_id');
    }

    /**
     * @inheritDoc
     *
     * Decode JSON hydrated data
     */
    public function load(AbstractModel $object, $value, $field = null)
    {
        parent::load($object, $value, $field);

        $dataJson = $object->getData(Model::ALLOWED_COUNTRIES);
        if ($dataJson !== null) {
            $object->setData(Model::ALLOWED_COUNTRIES, $this->jsonSerializer->unserialize($dataJson));
        }

        return $this;
    }

    /**
     * @inheritDoc
     *
     * Encode hydrated data
     */
    public function save(AbstractModel $object)
    {
        $data = $object->getData(Model::ALLOWED_COUNTRIES);
        if (is_array($data)) {
            $object->setData(Model::ALLOWED_COUNTRIES, $this->jsonSerializer->serialize($data));
        }

        parent::save($object);

        return $object->setData(Model::ALLOWED_COUNTRIES, $data);
    }
}
