<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-07-05
 ******************************************************************************/

namespace Fastmag\Sync\Process\Entity\ToFastmag\Order;

use Fastmag\Sync\Process\EntityInterface;

/**
 * Class Order
 *
 * Entity class for order.
 * Save and transform data from Magento for Fastmag easy integration,
 * and transfer it from hydration worker to integration worker
 */
class Item implements EntityInterface
{
    /** @var int $magentoId */
    protected $magentoId;

    /** @var int $parentItemId */
    protected $parentItemId;

    /** @var int $fastmagId */
    protected $fastmagId;

    /** @var string $fastmagId */
    protected $name;

    /** @var float $price */
    protected $priceInclTax;

    /** @var int $qtyCancelled */
    protected $qtyOrdered;

    /** @var int $qtyCanceled */
    protected $qtyCanceled;

    /** @var float $discountAmount */
    protected $discountAmount;

    /** @var float $rowTotal */
    protected $rowTotalInclTax;

    /** @var string $fastmagBarcode */
    protected $fastmagBarcode;

    /** @var string $fastmagSize */
    protected $fastmagSize;

    /** @var string $fastmagColor */
    protected $fastmagColor;

    /**
     * Get Magento ID
     *
     * @return int
     */
    public function getMagentoId()
    {
        return $this->magentoId;
    }

    /**
     * Get parent item ID
     *
     * @return int
     */
    public function getParentItemId()
    {
        return $this->parentItemId;
    }

    /**
     * Get Fastmag ID
     *
     * @return int
     */
    public function getFastmagId()
    {
        return $this->fastmagId;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get price including tax
     *
     * @return float
     */
    public function getPriceInclTax()
    {
        return $this->priceInclTax;
    }

    /**
     * Get quantity ordered
     *
     * @return int
     */
    public function getQtyOrdered()
    {
        return $this->qtyOrdered;
    }

    /**
     * Get quantity canceled
     *
     * @return int
     */
    public function getQtyCanceled()
    {
        return $this->qtyCanceled;
    }

    /**
     * Get discount amount
     *
     * @return float
     */
    public function getDiscountAmount()
    {
        return $this->discountAmount;
    }

    /**
     * Get row total including tax
     *
     * @return float
     */
    public function getRowTotalInclTax()
    {
        return $this->rowTotalInclTax;
    }

    /**
     * Get Fastmag barcode
     *
     * @return string
     */
    public function getFastmagBarcode()
    {
        return $this->fastmagBarcode;
    }

    /**
     * Get Fastmag size
     *
     * @return string
     */
    public function getFastmagSize()
    {
        return $this->fastmagSize;
    }

    /**
     * Get Fastmag color
     *
     * @return string
     */
    public function getFastmagColor()
    {
        return $this->fastmagColor;
    }

    /**
     * Set Magento ID
     *
     * @param int $magentoId
     *
     * @return Item
     */
    public function setMagentoId($magentoId)
    {
        $this->magentoId = $magentoId;

        return $this;
    }

    /**
     * Set parent item ID
     *
     * @param int $parentItemId
     *
     * @return Item
     */
    public function setParentItemId($parentItemId)
    {
        $this->parentItemId = $parentItemId;

        return $this;
    }

    /**
     * Set Fastmag ID
     *
     * @param int $fastmagId
     *
     * @return Item
     */
    public function setFastmagId($fastmagId)
    {
        $this->fastmagId = $fastmagId;

        return $this;
    }

    /**
     * Set name
     *
     * @param string $name
     *
     * @return Item
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Set price including tax
     *
     * @param float $priceInclTax
     *
     * @return Item
     */
    public function setPriceInclTax($priceInclTax)
    {
        $this->priceInclTax = $priceInclTax;

        return $this;
    }

    /**
     * Set quantity ordered
     *
     * @param int $qtyOrdered
     *
     * @return Item
     */
    public function setQtyOrdered($qtyOrdered)
    {
        $this->qtyOrdered = $qtyOrdered;

        return $this;
    }

    /**
     * Set quantity canceled
     *
     * @param int $qtyCanceled
     *
     * @return Item
     */
    public function setQtyCanceled($qtyCanceled)
    {
        $this->qtyCanceled = $qtyCanceled;

        return $this;
    }

    /**
     * Set discount amount
     *
     * @param float $discountAmount
     *
     * @return Item
     */
    public function setDiscountAmount($discountAmount)
    {
        $this->discountAmount = $discountAmount;

        return $this;
    }

    /**
     * Set row total including tax
     *
     * @param float $rowTotalInclTax
     *
     * @return Item
     */
    public function setRowTotalInclTax($rowTotalInclTax)
    {
        $this->rowTotalInclTax = $rowTotalInclTax;

        return $this;
    }

    /**
     * Set Fastmag barcode
     *
     * @param string $fastmagBarcode
     *
     * @return Item
     */
    public function setFastmagBarcode($fastmagBarcode)
    {
        $this->fastmagBarcode = $fastmagBarcode;

        return $this;
    }

    /**
     * Set Fastmag size
     *
     * @param string $fastmagSize
     *
     * @return Item
     */
    public function setFastmagSize($fastmagSize)
    {
        $this->fastmagSize = $fastmagSize;

        return $this;
    }

    /**
     * Set Fastmag color
     *
     * @param string $fastmagColor
     *
     * @return Item
     */
    public function setFastmagColor($fastmagColor)
    {
        $this->fastmagColor = $fastmagColor;

        return $this;
    }

    /**
     * @inheritDoc
     */
    public function export()
    {
        return [
            'item_id'            => $this->getMagentoId(),
            'parent_item_id'     => $this->getParentItemId(),
            'fastmag_product_id' => $this->getFastmagId(),
            'name'               => $this->getName(),
            'qty_ordered'        => $this->getQtyOrdered(),
            'qty_canceled'       => $this->getQtyCanceled(),
            'price_incl_tax'     => $this->getPriceInclTax(),
            'discount_amount'    => $this->getDiscountAmount(),
            'row_total_incl_tax' => $this->getRowTotalInclTax(),
            'fastmag_barcode'    => $this->getFastmagBarcode(),
            'fastmag_size'       => $this->getFastmagSize()
        ];
    }
}
