<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-09-16
 ******************************************************************************/

namespace Fastmag\Sync\Process\Entity\ToFastmag;

use Fastmag\Sync\Process\EntityInterface;
use Fastmag\Sync\Process\Entity\Helper\Attribute\Prefix;
use Magento\Framework\DataObject;

/**
 * Class Address
 *
 * Entity class for address.
 * Save and transform data from Magento for Fastmag easy integration,
 * and transfer it from hydration worker to integration worker
 *
 * @method string|null getAlias()
 * @method int|null getMagentoId()
 * @method string|null getFirstname()
 * @method string|null getLastname()
 * @method string|null getCompany()
 * @method string[]|null getStreet()
 * @method string|null getPostcode()
 * @method string|null getCity()
 * @method string|null getCountryId()
 * @method string|null getPhoneNumber()
 * @method Address setAlias(string $alias)
 * @method Address setMagentoId(int $magentoId)
 * @method Address setPrefix(string $prefix)
 * @method Address setFirstname(string $firstname)
 * @method Address setLastname(string $lastname)
 * @method Address setCompany(string $company)
 * @method Address setStreet(string[] $street)
 * @method Address setPostcode(string $postcode)
 * @method Address setCity(string $city)
 * @method Address setCountryId(string $countryId)
 * @method Address setPhoneNumber(string $phoneNumber)
 * @method Address setArchive(bool $archive)
 */
class Address extends DataObject implements EntityInterface
{
    /**
     * Get prefix
     *
     * @return string|null
     */
    public function getPrefix()
    {
        return $this->getData('prefix') !== null ? Prefix::getFastmagValue($this->getData('prefix')) : null;
    }

    /**
     * Get first line of street
     *
     * @return string|null
     */
    public function getStreetOne()
    {
        return is_array($this->getData('street')) ? $this->getData('street')[0] : null;
    }

    /**
     * Get second line of street
     *
     * @return string|null
     */
    public function getStreetTwo()
    {
        return is_array($this->getData('street') && count($this->getData('street')) > 0)
            ? $this->getData('street')[1] : null;
    }

    /**
     * Get is archived boolean
     *
     * @return bool
     */
    public function getArchive()
    {
        return $this->getData('archive') !== null ? (bool)$this->getData('archive') : null;
    }

    /**
     * @inheritDoc
     */
    public function export()
    {
        $result = [
            'alias'     => $this->getAlias(),
            'prefix'    => $this->getPrefix(),
            'lastname'  => $this->getLastname(),
            'firstname' => $this->getFirstname(),
            'company'   => $this->getCompany(),
            'street1'   => $this->getStreetOne(),
            'street2'   => $this->getStreetTwo(),
            'postcode'  => $this->getPostcode(),
            'city'      => $this->getCity(),
            'country'   => $this->getCountryId(),
            'phone'     => $this->getPhoneNumber(),
            'archive'   => $this->getArchive()
        ];

        return array_filter(
            $result,
            static function ($value) {
                return $value !== null && $value !== [];
            }
        );
    }
}
