<?php
/*******************************************************************************
 * Created by HOMEMADE.IO SAS.
 * Fastmag Sync  -  Connect Fastmag with your Magento
 *
 * Copyright (C) HOMEMADE.IO SAS, Inc - All Rights Reserved
 *
 * @author    Simon Laubet-Xavier <simon.laubetxavier@home-made.io>
 * @copyright 2020-2021 HOMEMADE.IO SAS
 * @date      2021-08-23
 ******************************************************************************/

namespace Fastmag\Sync\Process\Worker\ToMagento;

use DateInterval;
use DateTime;
use Exception;
use Fastmag\Sync\Api\Data\Jobqueue\ToMagentoInterface as Job;
use Fastmag\Sync\Exception\ProcessException;
use Fastmag\Sync\Logger\Logger;
use Fastmag\Sync\Model\Jobqueue as AbstractJob;
use Fastmag\Sync\Model\Jobqueue\ToMagentoRepository as JobRepository;
use Fastmag\Sync\Process\Worker;
use Fastmag\Sync\Process\Worker\Clean as CleanTrait;
use Magento\Framework\Api\SearchCriteriaBuilder;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Exception\CouldNotDeleteException;

/**
 * Class Clean
 *
 * Worker class used for cleaning to Magento jobs finished since more than 45 minutes
 */
class Clean extends Worker
{
    use CleanTrait;

    /** @inheritDoc */
    protected $code = 'tomagento_clean';

    /** @var SearchCriteriaBuilder $searchCriteriaBuilder */
    protected $searchCriteriaBuilder;

    /** @var JobRepository $jobRepository */
    protected $jobRepository;

    /**
     * Clean constructor.
     *
     * @param Logger                $logger
     * @param ResourceConnection    $resourceConnection
     * @param SearchCriteriaBuilder $searchCriteriaBuilder
     * @param JobRepository         $jobRepository
     */
    public function __construct(
        Logger $logger,
        ResourceConnection $resourceConnection,
        SearchCriteriaBuilder $searchCriteriaBuilder,
        JobRepository $jobRepository
    ) {
        parent::__construct($logger);

        $this->resourceConnection = $resourceConnection;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->jobRepository = $jobRepository;
    }

    /**
     * @inheritDoc
     *
     * @throws ProcessException
     */
    public function run()
    {
        try {
            $limitDatetime = new DateTime();
            $limitDatetime->sub(new DateInterval('PT45M'));
        } catch (Exception $exception) {
            return;
        }

        $searchCriteria = $this->searchCriteriaBuilder
            ->addFilter(Job::STATUS, AbstractJob::STATUS_OK)
            ->addFilter(Job::PROCESSED_AT, $limitDatetime->format('Y-m-d H:i:s'), 'lt')
            ->create();

        $jobsToDelete = $this->jobRepository->getList($searchCriteria);

        foreach ($jobsToDelete->getItems() as $job) {
            try {
                $this->jobRepository->delete($job);
            } catch (CouldNotDeleteException $exception) {
                throw new ProcessException(__($exception->getMessage()));
            }
        }

        $this->setLastExecutionDate();
    }
}
